@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.kotlin.outputs.ZoneVpc
import com.pulumi.aws.route53.kotlin.outputs.ZoneVpc.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Zone].
 */
@PulumiTagMarker
public class ZoneResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ZoneArgs = ZoneArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ZoneArgsBuilder.() -> Unit) {
        val builder = ZoneArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Zone {
        val builtJavaResource = com.pulumi.aws.route53.Zone(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Zone(builtJavaResource)
    }
}

/**
 * Manages a Route53 Hosted Zone. For managing Domain Name System Security Extensions (DNSSEC), see the `aws.route53.KeySigningKey` and `aws.route53.HostedZoneDnsSec` resources.
 * ## Example Usage
 * ### Public Zone
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const primary = new aws.route53.Zone("primary", {name: "example.com"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * primary = aws.route53.Zone("primary", name="example.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var primary = new Aws.Route53.Zone("primary", new()
 *     {
 *         Name = "example.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewZone(ctx, "primary", &route53.ZoneArgs{
 * 			Name: pulumi.String("example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Zone("primary", ZoneArgs.builder()
 *             .name("example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   primary:
 *     type: aws:route53:Zone
 *     properties:
 *       name: example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Public Subdomain Zone
 * For use in subdomains, note that you need to create a
 * `aws.route53.Record` of type `NS` as well as the subdomain
 * zone.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.route53.Zone("main", {name: "example.com"});
 * const dev = new aws.route53.Zone("dev", {
 *     name: "dev.example.com",
 *     tags: {
 *         Environment: "dev",
 *     },
 * });
 * const dev_ns = new aws.route53.Record("dev-ns", {
 *     zoneId: main.zoneId,
 *     name: "dev.example.com",
 *     type: aws.route53.RecordType.NS,
 *     ttl: 30,
 *     records: dev.nameServers,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.route53.Zone("main", name="example.com")
 * dev = aws.route53.Zone("dev",
 *     name="dev.example.com",
 *     tags={
 *         "Environment": "dev",
 *     })
 * dev_ns = aws.route53.Record("dev-ns",
 *     zone_id=main.zone_id,
 *     name="dev.example.com",
 *     type=aws.route53.RecordType.NS,
 *     ttl=30,
 *     records=dev.name_servers)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Route53.Zone("main", new()
 *     {
 *         Name = "example.com",
 *     });
 *     var dev = new Aws.Route53.Zone("dev", new()
 *     {
 *         Name = "dev.example.com",
 *         Tags =
 *         {
 *             { "Environment", "dev" },
 *         },
 *     });
 *     var dev_ns = new Aws.Route53.Record("dev-ns", new()
 *     {
 *         ZoneId = main.ZoneId,
 *         Name = "dev.example.com",
 *         Type = Aws.Route53.RecordType.NS,
 *         Ttl = 30,
 *         Records = dev.NameServers,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := route53.NewZone(ctx, "main", &route53.ZoneArgs{
 * 			Name: pulumi.String("example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		dev, err := route53.NewZone(ctx, "dev", &route53.ZoneArgs{
 * 			Name: pulumi.String("dev.example.com"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("dev"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewRecord(ctx, "dev-ns", &route53.RecordArgs{
 * 			ZoneId:  main.ZoneId,
 * 			Name:    pulumi.String("dev.example.com"),
 * 			Type:    pulumi.String(route53.RecordTypeNS),
 * 			Ttl:     pulumi.Int(30),
 * 			Records: dev.NameServers,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Zone("main", ZoneArgs.builder()
 *             .name("example.com")
 *             .build());
 *         var dev = new Zone("dev", ZoneArgs.builder()
 *             .name("dev.example.com")
 *             .tags(Map.of("Environment", "dev"))
 *             .build());
 *         var dev_ns = new Record("dev-ns", RecordArgs.builder()
 *             .zoneId(main.zoneId())
 *             .name("dev.example.com")
 *             .type("NS")
 *             .ttl("30")
 *             .records(dev.nameServers())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:route53:Zone
 *     properties:
 *       name: example.com
 *   dev:
 *     type: aws:route53:Zone
 *     properties:
 *       name: dev.example.com
 *       tags:
 *         Environment: dev
 *   dev-ns:
 *     type: aws:route53:Record
 *     properties:
 *       zoneId: ${main.zoneId}
 *       name: dev.example.com
 *       type: NS
 *       ttl: '30'
 *       records: ${dev.nameServers}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Private Zone
 * > **NOTE:** This provider provides both exclusive VPC associations defined in-line in this resource via `vpc` configuration blocks and a separate `Zone VPC Association resource. At this time, you cannot use in-line VPC associations in conjunction with any `aws.route53.ZoneAssociation` resources with the same zone ID otherwise it will cause a perpetual difference in plan output. You can optionally use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to manage additional associations via the `aws.route53.ZoneAssociation` resource.
 * > **NOTE:** Private zones require at least one VPC association at all times.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _private = new aws.route53.Zone("private", {
 *     name: "example.com",
 *     vpcs: [{
 *         vpcId: example.id,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * private = aws.route53.Zone("private",
 *     name="example.com",
 *     vpcs=[{
 *         "vpc_id": example["id"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @private = new Aws.Route53.Zone("private", new()
 *     {
 *         Name = "example.com",
 *         Vpcs = new[]
 *         {
 *             new Aws.Route53.Inputs.ZoneVpcArgs
 *             {
 *                 VpcId = example.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewZone(ctx, "private", &route53.ZoneArgs{
 * 			Name: pulumi.String("example.com"),
 * 			Vpcs: route53.ZoneVpcArray{
 * 				&route53.ZoneVpcArgs{
 * 					VpcId: pulumi.Any(example.Id),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import com.pulumi.aws.route53.inputs.ZoneVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var private_ = new Zone("private", ZoneArgs.builder()
 *             .name("example.com")
 *             .vpcs(ZoneVpcArgs.builder()
 *                 .vpcId(example.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   private:
 *     type: aws:route53:Zone
 *     properties:
 *       name: example.com
 *       vpcs:
 *         - vpcId: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Zones using the zone `id`. For example:
 * ```sh
 * $ pulumi import aws:route53/zone:Zone myzone Z1D633PJN98FT9
 * ```
 */
public class Zone internal constructor(
    override val javaResource: com.pulumi.aws.route53.Zone,
) : KotlinCustomResource(javaResource, ZoneMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Hosted Zone.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A comment for the hosted zone. Defaults to 'Managed by Pulumi'.
     */
    public val comment: Output<String>
        get() = javaResource.comment().applyValue({ args0 -> args0 })

    /**
     * The ID of the reusable delegation set whose NS records you want to assign to the hosted zone. Conflicts with `vpc` as delegation sets can only be used for public zones.
     */
    public val delegationSetId: Output<String>?
        get() = javaResource.delegationSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to destroy all records (possibly managed outside of this provider) in the zone when destroying the zone.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is the name of the hosted zone.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of name servers in associated (or default) delegation set.
     * Find more about delegation sets in [AWS docs](https://docs.aws.amazon.com/Route53/latest/APIReference/actions-on-reusable-delegation-sets.html).
     */
    public val nameServers: Output<List<String>>
        get() = javaResource.nameServers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The Route 53 name server that created the SOA record.
     */
    public val primaryNameServer: Output<String>
        get() = javaResource.primaryNameServer().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block(s) specifying VPC(s) to associate with a private hosted zone. Conflicts with the `delegation_set_id` argument in this resource and any `aws.route53.ZoneAssociation` resource specifying the same zone ID. Detailed below.
     */
    public val vpcs: Output<List<ZoneVpc>>?
        get() = javaResource.vpcs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The Hosted Zone ID. This can be referenced by zone records.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object ZoneMapper : ResourceMapper<Zone> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.Zone::class == javaResource::class

    override fun map(javaResource: Resource): Zone = Zone(javaResource as com.pulumi.aws.route53.Zone)
}

/**
 * @see [Zone].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Zone].
 */
public suspend fun zone(name: String, block: suspend ZoneResourceBuilder.() -> Unit): Zone {
    val builder = ZoneResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Zone].
 * @param name The _unique_ name of the resulting resource.
 */
public fun zone(name: String): Zone {
    val builder = ZoneResourceBuilder()
    builder.name(name)
    return builder.build()
}
