@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetDelegationSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDelegationSet.
 * @property id Delegation set ID.
 * The following attribute is additionally exported:
 */
public data class GetDelegationSetPlainArgs(
    public val id: String,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetDelegationSetPlainArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetDelegationSetPlainArgs =
        com.pulumi.aws.route53.inputs.GetDelegationSetPlainArgs.builder()
            .id(id.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDelegationSetPlainArgs].
 */
@PulumiTagMarker
public class GetDelegationSetPlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value Delegation set ID.
     * The following attribute is additionally exported:
     */
    @JvmName("ixgiwppxawsjuyga")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetDelegationSetPlainArgs = GetDelegationSetPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
