@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetQueryLogConfigFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the query logging configuration.
 * @property values
 */
public data class GetQueryLogConfigFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetQueryLogConfigFilter> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetQueryLogConfigFilter =
        com.pulumi.aws.route53.inputs.GetQueryLogConfigFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetQueryLogConfigFilter].
 */
@PulumiTagMarker
public class GetQueryLogConfigFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value The name of the query logging configuration.
     */
    @JvmName("mnagriaogqjajuqa")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("qwypbcykiixgtsfc")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("tkkqnnbleohnucjs")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetQueryLogConfigFilter = GetQueryLogConfigFilter(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
