@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetResolverEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResolverEndpoint.
 * @property filters One or more name/value pairs to use as filters. There are
 * several valid keys, for a full reference, check out
 * [Route53resolver Filter value in the AWS API reference][1].
 * In addition to all arguments above, the following attributes are exported:
 * @property resolverEndpointId ID of the Route53 Resolver Endpoint.
 */
public data class GetResolverEndpointPlainArgs(
    public val filters: List<GetResolverEndpointFilter>? = null,
    public val resolverEndpointId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetResolverEndpointPlainArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetResolverEndpointPlainArgs =
        com.pulumi.aws.route53.inputs.GetResolverEndpointPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .resolverEndpointId(resolverEndpointId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResolverEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetResolverEndpointPlainArgsBuilder internal constructor() {
    private var filters: List<GetResolverEndpointFilter>? = null

    private var resolverEndpointId: String? = null

    /**
     * @param value One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     */
    @JvmName("trylkivcpdlmieso")
    public suspend fun filters(`value`: List<GetResolverEndpointFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     */
    @JvmName("fxtntfivdsebeuku")
    public suspend fun filters(argument: List<suspend GetResolverEndpointFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetResolverEndpointFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     */
    @JvmName("eudhdtuogmcitcng")
    public suspend fun filters(vararg argument: suspend GetResolverEndpointFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetResolverEndpointFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     */
    @JvmName("ykphbelaytejycnt")
    public suspend fun filters(argument: suspend GetResolverEndpointFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetResolverEndpointFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     */
    @JvmName("tilgwvsvolfksqck")
    public suspend fun filters(vararg values: GetResolverEndpointFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the Route53 Resolver Endpoint.
     */
    @JvmName("ofqqyowdteoxnhil")
    public suspend fun resolverEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resolverEndpointId = mapped
    }

    internal fun build(): GetResolverEndpointPlainArgs = GetResolverEndpointPlainArgs(
        filters = filters,
        resolverEndpointId = resolverEndpointId,
    )
}
