@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetResolverFirewallConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResolverFirewallConfig.
 * @property resourceId The ID of the VPC from Amazon VPC that the configuration is for.
 * The following attribute is additionally exported:
 */
public data class GetResolverFirewallConfigPlainArgs(
    public val resourceId: String,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetResolverFirewallConfigPlainArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetResolverFirewallConfigPlainArgs =
        com.pulumi.aws.route53.inputs.GetResolverFirewallConfigPlainArgs.builder()
            .resourceId(resourceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResolverFirewallConfigPlainArgs].
 */
@PulumiTagMarker
public class GetResolverFirewallConfigPlainArgsBuilder internal constructor() {
    private var resourceId: String? = null

    /**
     * @param value The ID of the VPC from Amazon VPC that the configuration is for.
     * The following attribute is additionally exported:
     */
    @JvmName("vmaltotouypshaes")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    internal fun build(): GetResolverFirewallConfigPlainArgs = GetResolverFirewallConfigPlainArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
