@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetResolverFirewallRuleGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResolverFirewallRuleGroup.
 * @property firewallRuleGroupId The ID of the rule group.
 * The following attribute is additionally exported:
 */
public data class GetResolverFirewallRuleGroupPlainArgs(
    public val firewallRuleGroupId: String,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetResolverFirewallRuleGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetResolverFirewallRuleGroupPlainArgs =
        com.pulumi.aws.route53.inputs.GetResolverFirewallRuleGroupPlainArgs.builder()
            .firewallRuleGroupId(firewallRuleGroupId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResolverFirewallRuleGroupPlainArgs].
 */
@PulumiTagMarker
public class GetResolverFirewallRuleGroupPlainArgsBuilder internal constructor() {
    private var firewallRuleGroupId: String? = null

    /**
     * @param value The ID of the rule group.
     * The following attribute is additionally exported:
     */
    @JvmName("nqrqmyxfspqppdtg")
    public suspend fun firewallRuleGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallRuleGroupId = mapped
    }

    internal fun build(): GetResolverFirewallRuleGroupPlainArgs =
        GetResolverFirewallRuleGroupPlainArgs(
            firewallRuleGroupId = firewallRuleGroupId ?: throw PulumiNullFieldException("firewallRuleGroupId"),
        )
}
