@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetResolverRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResolverRule.
 * @property domainName Domain name the desired resolver rule forwards DNS queries for. Conflicts with `resolver_rule_id`.
 * @property name Friendly name of the desired resolver rule. Conflicts with `resolver_rule_id`.
 * @property resolverEndpointId ID of the outbound resolver endpoint of the desired resolver rule. Conflicts with `resolver_rule_id`.
 * @property resolverRuleId ID of the desired resolver rule. Conflicts with `domain_name`, `name`, `resolver_endpoint_id` and `rule_type`.
 * @property ruleType Rule type of the desired resolver rule. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`. Conflicts with `resolver_rule_id`.
 * @property tags Map of tags assigned to the resolver rule.
 */
public data class GetResolverRulePlainArgs(
    public val domainName: String? = null,
    public val name: String? = null,
    public val resolverEndpointId: String? = null,
    public val resolverRuleId: String? = null,
    public val ruleType: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetResolverRulePlainArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetResolverRulePlainArgs =
        com.pulumi.aws.route53.inputs.GetResolverRulePlainArgs.builder()
            .domainName(domainName?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .resolverEndpointId(resolverEndpointId?.let({ args0 -> args0 }))
            .resolverRuleId(resolverRuleId?.let({ args0 -> args0 }))
            .ruleType(ruleType?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetResolverRulePlainArgs].
 */
@PulumiTagMarker
public class GetResolverRulePlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var name: String? = null

    private var resolverEndpointId: String? = null

    private var resolverRuleId: String? = null

    private var ruleType: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Domain name the desired resolver rule forwards DNS queries for. Conflicts with `resolver_rule_id`.
     */
    @JvmName("cjtlkdaceeqfivyl")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Friendly name of the desired resolver rule. Conflicts with `resolver_rule_id`.
     */
    @JvmName("yyyvwxjumhihhuie")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value ID of the outbound resolver endpoint of the desired resolver rule. Conflicts with `resolver_rule_id`.
     */
    @JvmName("gelacegadwennhme")
    public suspend fun resolverEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resolverEndpointId = mapped
    }

    /**
     * @param value ID of the desired resolver rule. Conflicts with `domain_name`, `name`, `resolver_endpoint_id` and `rule_type`.
     */
    @JvmName("xgkrsrjnypllqlid")
    public suspend fun resolverRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resolverRuleId = mapped
    }

    /**
     * @param value Rule type of the desired resolver rule. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`. Conflicts with `resolver_rule_id`.
     */
    @JvmName("admpqahinebnwefp")
    public suspend fun ruleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ruleType = mapped
    }

    /**
     * @param value Map of tags assigned to the resolver rule.
     */
    @JvmName("krnrrpngieuhercr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resolver rule.
     */
    @JvmName("rsfgmghuwlgcrnvi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetResolverRulePlainArgs = GetResolverRulePlainArgs(
        domainName = domainName,
        name = name,
        resolverEndpointId = resolverEndpointId,
        resolverRuleId = resolverRuleId,
        ruleType = ruleType,
        tags = tags,
    )
}
