@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentEndpoint.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id ID of an endpoint you want to assign.
 * @property region To route traffic to an Amazon S3 bucket that is configured as a website endpoint, specify the region in which you created the bucket for `region`.
 * @property type Type of the endpoint. Valid values are `value`, `cloudfront`, `elastic-load-balancer`, `s3-website`, `application-load-balancer`, `network-load-balancer` and `elastic-beanstalk`
 * @property value Value of the `type`.
 */
public data class GetTrafficPolicyDocumentEndpoint(
    public val id: String,
    public val region: String? = null,
    public val type: String? = null,
    public val `value`: String? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentEndpoint> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentEndpoint =
        com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentEndpoint.builder()
            .id(id.let({ args0 -> args0 }))
            .region(region?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 }))
            .`value`(`value`?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficPolicyDocumentEndpoint].
 */
@PulumiTagMarker
public class GetTrafficPolicyDocumentEndpointBuilder internal constructor() {
    private var id: String? = null

    private var region: String? = null

    private var type: String? = null

    private var `value`: String? = null

    /**
     * @param value ID of an endpoint you want to assign.
     */
    @JvmName("bixkidhsfllhavbf")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value To route traffic to an Amazon S3 bucket that is configured as a website endpoint, specify the region in which you created the bucket for `region`.
     */
    @JvmName("bsrpihdetxhqhukv")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.region = mapped
    }

    /**
     * @param value Type of the endpoint. Valid values are `value`, `cloudfront`, `elastic-load-balancer`, `s3-website`, `application-load-balancer`, `network-load-balancer` and `elastic-beanstalk`
     */
    @JvmName("cdaabteplfmkxgre")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value Value of the `type`.
     */
    @JvmName("vmcpagrjfuywrood")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.`value` = mapped
    }

    internal fun build(): GetTrafficPolicyDocumentEndpoint = GetTrafficPolicyDocumentEndpoint(
        id = id ?: throw PulumiNullFieldException("id"),
        region = region,
        type = type,
        `value` = `value`,
    )
}
