@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRule.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property geoProximityLocations Configuration block for when you add a geoproximity rule, you configure Amazon Route 53 to route traffic to your resources based on the geographic location of your resources. Only valid for `geoproximity` type. See below
 * @property id ID of a rule you want to assign.
 * @property items Configuration block for when you add a multivalue answer rule, you configure your traffic policy to route traffic approximately randomly to your healthy resources.  Only valid for `multivalue` type. See below
 * @property locations Configuration block for when you add a geolocation rule, you configure your traffic policy to route your traffic based on the geographic location of your users.  Only valid for `geo` type. See below
 * @property primary Configuration block for the settings for the rule or endpoint that you want to route traffic to whenever the corresponding resources are available. Only valid for `failover` type. See below
 * @property regions
 * @property secondary Configuration block for the rule or endpoint that you want to route traffic to whenever the primary resources are not available. Only valid for `failover` type. See below
 * @property type Type of the rule.
 */
public data class GetTrafficPolicyDocumentRule(
    public val geoProximityLocations: List<GetTrafficPolicyDocumentRuleGeoProximityLocation>? = null,
    public val id: String,
    public val items: List<GetTrafficPolicyDocumentRuleItem>? = null,
    public val locations: List<GetTrafficPolicyDocumentRuleLocation>? = null,
    public val primary: GetTrafficPolicyDocumentRulePrimary? = null,
    public val regions: List<GetTrafficPolicyDocumentRuleRegion>? = null,
    public val secondary: GetTrafficPolicyDocumentRuleSecondary? = null,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRule> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRule =
        com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRule.builder()
            .geoProximityLocations(
                geoProximityLocations?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id.let({ args0 -> args0 }))
            .items(items?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .locations(locations?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .primary(primary?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regions(regions?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .secondary(secondary?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficPolicyDocumentRule].
 */
@PulumiTagMarker
public class GetTrafficPolicyDocumentRuleBuilder internal constructor() {
    private var geoProximityLocations: List<GetTrafficPolicyDocumentRuleGeoProximityLocation>? = null

    private var id: String? = null

    private var items: List<GetTrafficPolicyDocumentRuleItem>? = null

    private var locations: List<GetTrafficPolicyDocumentRuleLocation>? = null

    private var primary: GetTrafficPolicyDocumentRulePrimary? = null

    private var regions: List<GetTrafficPolicyDocumentRuleRegion>? = null

    private var secondary: GetTrafficPolicyDocumentRuleSecondary? = null

    private var type: String? = null

    /**
     * @param value Configuration block for when you add a geoproximity rule, you configure Amazon Route 53 to route traffic to your resources based on the geographic location of your resources. Only valid for `geoproximity` type. See below
     */
    @JvmName("aghkxveemlgmkbma")
    public suspend fun geoProximityLocations(`value`: List<GetTrafficPolicyDocumentRuleGeoProximityLocation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.geoProximityLocations = mapped
    }

    /**
     * @param argument Configuration block for when you add a geoproximity rule, you configure Amazon Route 53 to route traffic to your resources based on the geographic location of your resources. Only valid for `geoproximity` type. See below
     */
    @JvmName("xpofprpvkwbgiuwb")
    public suspend fun geoProximityLocations(argument: List<suspend GetTrafficPolicyDocumentRuleGeoProximityLocationBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentRuleGeoProximityLocationBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.geoProximityLocations = mapped
    }

    /**
     * @param argument Configuration block for when you add a geoproximity rule, you configure Amazon Route 53 to route traffic to your resources based on the geographic location of your resources. Only valid for `geoproximity` type. See below
     */
    @JvmName("ehulurrmofbyfhqm")
    public suspend fun geoProximityLocations(vararg argument: suspend GetTrafficPolicyDocumentRuleGeoProximityLocationBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentRuleGeoProximityLocationBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.geoProximityLocations = mapped
    }

    /**
     * @param argument Configuration block for when you add a geoproximity rule, you configure Amazon Route 53 to route traffic to your resources based on the geographic location of your resources. Only valid for `geoproximity` type. See below
     */
    @JvmName("qyullffpindnspne")
    public suspend fun geoProximityLocations(argument: suspend GetTrafficPolicyDocumentRuleGeoProximityLocationBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetTrafficPolicyDocumentRuleGeoProximityLocationBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.geoProximityLocations = mapped
    }

    /**
     * @param values Configuration block for when you add a geoproximity rule, you configure Amazon Route 53 to route traffic to your resources based on the geographic location of your resources. Only valid for `geoproximity` type. See below
     */
    @JvmName("ldhhlgjxvtjlhsyu")
    public suspend fun geoProximityLocations(vararg values: GetTrafficPolicyDocumentRuleGeoProximityLocation) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.geoProximityLocations = mapped
    }

    /**
     * @param value ID of a rule you want to assign.
     */
    @JvmName("vnlrfjmfjsbjhusr")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Configuration block for when you add a multivalue answer rule, you configure your traffic policy to route traffic approximately randomly to your healthy resources.  Only valid for `multivalue` type. See below
     */
    @JvmName("uqdjexyyxhssrwss")
    public suspend fun items(`value`: List<GetTrafficPolicyDocumentRuleItem>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.items = mapped
    }

    /**
     * @param argument Configuration block for when you add a multivalue answer rule, you configure your traffic policy to route traffic approximately randomly to your healthy resources.  Only valid for `multivalue` type. See below
     */
    @JvmName("wkhfndfoakphftai")
    public suspend fun items(argument: List<suspend GetTrafficPolicyDocumentRuleItemBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentRuleItemBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.items = mapped
    }

    /**
     * @param argument Configuration block for when you add a multivalue answer rule, you configure your traffic policy to route traffic approximately randomly to your healthy resources.  Only valid for `multivalue` type. See below
     */
    @JvmName("mbxeknfqjcsbghkp")
    public suspend fun items(vararg argument: suspend GetTrafficPolicyDocumentRuleItemBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentRuleItemBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.items = mapped
    }

    /**
     * @param argument Configuration block for when you add a multivalue answer rule, you configure your traffic policy to route traffic approximately randomly to your healthy resources.  Only valid for `multivalue` type. See below
     */
    @JvmName("owudxlmwbjnedtbx")
    public suspend fun items(argument: suspend GetTrafficPolicyDocumentRuleItemBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetTrafficPolicyDocumentRuleItemBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.items = mapped
    }

    /**
     * @param values Configuration block for when you add a multivalue answer rule, you configure your traffic policy to route traffic approximately randomly to your healthy resources.  Only valid for `multivalue` type. See below
     */
    @JvmName("ulpcrpltfttouuxr")
    public suspend fun items(vararg values: GetTrafficPolicyDocumentRuleItem) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.items = mapped
    }

    /**
     * @param value Configuration block for when you add a geolocation rule, you configure your traffic policy to route your traffic based on the geographic location of your users.  Only valid for `geo` type. See below
     */
    @JvmName("maekhsbiprrobexk")
    public suspend fun locations(`value`: List<GetTrafficPolicyDocumentRuleLocation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.locations = mapped
    }

    /**
     * @param argument Configuration block for when you add a geolocation rule, you configure your traffic policy to route your traffic based on the geographic location of your users.  Only valid for `geo` type. See below
     */
    @JvmName("gmemrxcpaqiqttaf")
    public suspend fun locations(argument: List<suspend GetTrafficPolicyDocumentRuleLocationBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentRuleLocationBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.locations = mapped
    }

    /**
     * @param argument Configuration block for when you add a geolocation rule, you configure your traffic policy to route your traffic based on the geographic location of your users.  Only valid for `geo` type. See below
     */
    @JvmName("ymoanlrehvltfown")
    public suspend fun locations(vararg argument: suspend GetTrafficPolicyDocumentRuleLocationBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentRuleLocationBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.locations = mapped
    }

    /**
     * @param argument Configuration block for when you add a geolocation rule, you configure your traffic policy to route your traffic based on the geographic location of your users.  Only valid for `geo` type. See below
     */
    @JvmName("rcgmecxgvcnbhdew")
    public suspend fun locations(argument: suspend GetTrafficPolicyDocumentRuleLocationBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetTrafficPolicyDocumentRuleLocationBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.locations = mapped
    }

    /**
     * @param values Configuration block for when you add a geolocation rule, you configure your traffic policy to route your traffic based on the geographic location of your users.  Only valid for `geo` type. See below
     */
    @JvmName("qiyemeagvefyfycg")
    public suspend fun locations(vararg values: GetTrafficPolicyDocumentRuleLocation) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.locations = mapped
    }

    /**
     * @param value Configuration block for the settings for the rule or endpoint that you want to route traffic to whenever the corresponding resources are available. Only valid for `failover` type. See below
     */
    @JvmName("ddxibalhscwtjmft")
    public suspend fun primary(`value`: GetTrafficPolicyDocumentRulePrimary?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.primary = mapped
    }

    /**
     * @param argument Configuration block for the settings for the rule or endpoint that you want to route traffic to whenever the corresponding resources are available. Only valid for `failover` type. See below
     */
    @JvmName("dwvepdkenicklrej")
    public suspend fun primary(argument: suspend GetTrafficPolicyDocumentRulePrimaryBuilder.() -> Unit) {
        val toBeMapped = GetTrafficPolicyDocumentRulePrimaryBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.primary = mapped
    }

    /**
     * @param value
     */
    @JvmName("hipltamdodmigucw")
    public suspend fun regions(`value`: List<GetTrafficPolicyDocumentRuleRegion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uesdugxptnktqvcq")
    public suspend fun regions(argument: List<suspend GetTrafficPolicyDocumentRuleRegionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentRuleRegionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("soihdlulvntryely")
    public suspend fun regions(vararg argument: suspend GetTrafficPolicyDocumentRuleRegionBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentRuleRegionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bhjprhbyesiqjael")
    public suspend fun regions(argument: suspend GetTrafficPolicyDocumentRuleRegionBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetTrafficPolicyDocumentRuleRegionBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.regions = mapped
    }

    /**
     * @param values
     */
    @JvmName("wedjbnujurahgucq")
    public suspend fun regions(vararg values: GetTrafficPolicyDocumentRuleRegion) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param value Configuration block for the rule or endpoint that you want to route traffic to whenever the primary resources are not available. Only valid for `failover` type. See below
     */
    @JvmName("smuoawgsephoircq")
    public suspend fun secondary(`value`: GetTrafficPolicyDocumentRuleSecondary?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.secondary = mapped
    }

    /**
     * @param argument Configuration block for the rule or endpoint that you want to route traffic to whenever the primary resources are not available. Only valid for `failover` type. See below
     */
    @JvmName("crivlwfsmyxgvqos")
    public suspend fun secondary(argument: suspend GetTrafficPolicyDocumentRuleSecondaryBuilder.() -> Unit) {
        val toBeMapped = GetTrafficPolicyDocumentRuleSecondaryBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.secondary = mapped
    }

    /**
     * @param value Type of the rule.
     */
    @JvmName("fqculfmtesprltih")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetTrafficPolicyDocumentRule = GetTrafficPolicyDocumentRule(
        geoProximityLocations = geoProximityLocations,
        id = id ?: throw PulumiNullFieldException("id"),
        items = items,
        locations = locations,
        primary = primary,
        regions = regions,
        secondary = secondary,
        type = type,
    )
}
