@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleGeoProximityLocation.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bias Specify a value for `bias` if you want to route more traffic to an endpoint from nearby endpoints (positive values) or route less traffic to an endpoint (negative values).
 * @property endpointReference References to an endpoint.
 * @property evaluateTargetHealth Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
 * @property healthCheck If you want to associate a health check with the endpoint or rule.
 * @property latitude Represents the location south (negative) or north (positive) of the equator. Valid values are -90 degrees to 90 degrees.
 * @property longitude Represents the location west (negative) or east (positive) of the prime meridian. Valid values are -180 degrees to 180 degrees.
 * @property region If your endpoint is an AWS resource, specify the AWS Region that you created the resource in.
 * @property ruleReference References to a rule.
 */
public data class GetTrafficPolicyDocumentRuleGeoProximityLocation(
    public val bias: String? = null,
    public val endpointReference: String? = null,
    public val evaluateTargetHealth: Boolean? = null,
    public val healthCheck: String? = null,
    public val latitude: String? = null,
    public val longitude: String? = null,
    public val region: String? = null,
    public val ruleReference: String? = null,
) :
    ConvertibleToJava<com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleGeoProximityLocation> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleGeoProximityLocation =
        com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleGeoProximityLocation.builder()
            .bias(bias?.let({ args0 -> args0 }))
            .endpointReference(endpointReference?.let({ args0 -> args0 }))
            .evaluateTargetHealth(evaluateTargetHealth?.let({ args0 -> args0 }))
            .healthCheck(healthCheck?.let({ args0 -> args0 }))
            .latitude(latitude?.let({ args0 -> args0 }))
            .longitude(longitude?.let({ args0 -> args0 }))
            .region(region?.let({ args0 -> args0 }))
            .ruleReference(ruleReference?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficPolicyDocumentRuleGeoProximityLocation].
 */
@PulumiTagMarker
public class GetTrafficPolicyDocumentRuleGeoProximityLocationBuilder internal constructor() {
    private var bias: String? = null

    private var endpointReference: String? = null

    private var evaluateTargetHealth: Boolean? = null

    private var healthCheck: String? = null

    private var latitude: String? = null

    private var longitude: String? = null

    private var region: String? = null

    private var ruleReference: String? = null

    /**
     * @param value Specify a value for `bias` if you want to route more traffic to an endpoint from nearby endpoints (positive values) or route less traffic to an endpoint (negative values).
     */
    @JvmName("wukkwwwgcajintjb")
    public suspend fun bias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.bias = mapped
    }

    /**
     * @param value References to an endpoint.
     */
    @JvmName("tylrasofderqgaus")
    public suspend fun endpointReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointReference = mapped
    }

    /**
     * @param value Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
     */
    @JvmName("uivciiskelpyaidb")
    public suspend fun evaluateTargetHealth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.evaluateTargetHealth = mapped
    }

    /**
     * @param value If you want to associate a health check with the endpoint or rule.
     */
    @JvmName("gteceornwckbtgdu")
    public suspend fun healthCheck(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.healthCheck = mapped
    }

    /**
     * @param value Represents the location south (negative) or north (positive) of the equator. Valid values are -90 degrees to 90 degrees.
     */
    @JvmName("ggukeugxhrumqgeo")
    public suspend fun latitude(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.latitude = mapped
    }

    /**
     * @param value Represents the location west (negative) or east (positive) of the prime meridian. Valid values are -180 degrees to 180 degrees.
     */
    @JvmName("qprenmnxvmhjgblm")
    public suspend fun longitude(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.longitude = mapped
    }

    /**
     * @param value If your endpoint is an AWS resource, specify the AWS Region that you created the resource in.
     */
    @JvmName("oydsgxfgaibpjclw")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.region = mapped
    }

    /**
     * @param value References to a rule.
     */
    @JvmName("fenrqxpvfijjpncg")
    public suspend fun ruleReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ruleReference = mapped
    }

    internal fun build(): GetTrafficPolicyDocumentRuleGeoProximityLocation =
        GetTrafficPolicyDocumentRuleGeoProximityLocation(
            bias = bias,
            endpointReference = endpointReference,
            evaluateTargetHealth = evaluateTargetHealth,
            healthCheck = healthCheck,
            latitude = latitude,
            longitude = longitude,
            region = region,
            ruleReference = ruleReference,
        )
}
