@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleItem.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointReference
 * @property healthCheck
 */
public data class GetTrafficPolicyDocumentRuleItem(
    public val endpointReference: String? = null,
    public val healthCheck: String? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleItem> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleItem =
        com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleItem.builder()
            .endpointReference(endpointReference?.let({ args0 -> args0 }))
            .healthCheck(healthCheck?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficPolicyDocumentRuleItem].
 */
@PulumiTagMarker
public class GetTrafficPolicyDocumentRuleItemBuilder internal constructor() {
    private var endpointReference: String? = null

    private var healthCheck: String? = null

    /**
     * @param value
     */
    @JvmName("cwviymhfdkowhigc")
    public suspend fun endpointReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointReference = mapped
    }

    /**
     * @param value
     */
    @JvmName("fdcvqogtnpfukrai")
    public suspend fun healthCheck(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.healthCheck = mapped
    }

    internal fun build(): GetTrafficPolicyDocumentRuleItem = GetTrafficPolicyDocumentRuleItem(
        endpointReference = endpointReference,
        healthCheck = healthCheck,
    )
}
