@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetZonePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getZone.
 * @property name Hosted Zone name of the desired Hosted Zone.
 * @property privateZone Used with `name` field to get a private Hosted Zone.
 * @property tags Used with `name` field. A map of tags, each pair of which must exactly match a pair on the desired Hosted Zone.
 * @property vpcId Used with `name` field to get a private Hosted Zone associated with the vpc_id (in this case, private_zone is not mandatory).
 * @property zoneId Hosted Zone id of the desired Hosted Zone.
 */
public data class GetZonePlainArgs(
    public val name: String? = null,
    public val privateZone: Boolean? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetZonePlainArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetZonePlainArgs =
        com.pulumi.aws.route53.inputs.GetZonePlainArgs.builder()
            .name(name?.let({ args0 -> args0 }))
            .privateZone(privateZone?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZonePlainArgs].
 */
@PulumiTagMarker
public class GetZonePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var privateZone: Boolean? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    private var zoneId: String? = null

    /**
     * @param value Hosted Zone name of the desired Hosted Zone.
     */
    @JvmName("oqxbpbiporvpxeyb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Used with `name` field to get a private Hosted Zone.
     */
    @JvmName("nkyaonqaulntfeua")
    public suspend fun privateZone(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.privateZone = mapped
    }

    /**
     * @param value Used with `name` field. A map of tags, each pair of which must exactly match a pair on the desired Hosted Zone.
     */
    @JvmName("yajdkvvaaspodguo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Used with `name` field. A map of tags, each pair of which must exactly match a pair on the desired Hosted Zone.
     */
    @JvmName("jrclebogvbfdqjst")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Used with `name` field to get a private Hosted Zone associated with the vpc_id (in this case, private_zone is not mandatory).
     */
    @JvmName("dgqsilmidgolimwj")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    /**
     * @param value Hosted Zone id of the desired Hosted Zone.
     */
    @JvmName("vkmrffkipckpmjke")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetZonePlainArgs = GetZonePlainArgs(
        name = name,
        privateZone = privateZone,
        tags = tags,
        vpcId = vpcId,
        zoneId = zoneId,
    )
}
