@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.RecordAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property evaluateTargetHealth Set to `true` if you want Route 53 to determine whether to respond to DNS queries using this resource record set by checking the health of the resource record set. Some resources have special requirements, see [related part of documentation](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-values.html#rrsets-values-alias-evaluate-target-health).
 * @property name DNS domain name for a CloudFront distribution, S3 bucket, ELB, or another resource record set in this hosted zone.
 * @property zoneId Hosted zone ID for a CloudFront distribution, S3 bucket, ELB, or Route 53 hosted zone. See `resource_elb.zone_id` for example.
 */
public data class RecordAliasArgs(
    public val evaluateTargetHealth: Output<Boolean>,
    public val name: Output<String>,
    public val zoneId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.RecordAliasArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.RecordAliasArgs =
        com.pulumi.aws.route53.inputs.RecordAliasArgs.builder()
            .evaluateTargetHealth(evaluateTargetHealth.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .zoneId(zoneId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordAliasArgs].
 */
@PulumiTagMarker
public class RecordAliasArgsBuilder internal constructor() {
    private var evaluateTargetHealth: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Set to `true` if you want Route 53 to determine whether to respond to DNS queries using this resource record set by checking the health of the resource record set. Some resources have special requirements, see [related part of documentation](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-values.html#rrsets-values-alias-evaluate-target-health).
     */
    @JvmName("rjpepkboqmwxksbu")
    public suspend fun evaluateTargetHealth(`value`: Output<Boolean>) {
        this.evaluateTargetHealth = value
    }

    /**
     * @param value DNS domain name for a CloudFront distribution, S3 bucket, ELB, or another resource record set in this hosted zone.
     */
    @JvmName("qdavvkuypbdovyac")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Hosted zone ID for a CloudFront distribution, S3 bucket, ELB, or Route 53 hosted zone. See `resource_elb.zone_id` for example.
     */
    @JvmName("oyhyvmforvwvbwdm")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Set to `true` if you want Route 53 to determine whether to respond to DNS queries using this resource record set by checking the health of the resource record set. Some resources have special requirements, see [related part of documentation](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-values.html#rrsets-values-alias-evaluate-target-health).
     */
    @JvmName("csecykiwmsdftdmo")
    public suspend fun evaluateTargetHealth(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evaluateTargetHealth = mapped
    }

    /**
     * @param value DNS domain name for a CloudFront distribution, S3 bucket, ELB, or another resource record set in this hosted zone.
     */
    @JvmName("ljbdrsuppcaqgiqs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Hosted zone ID for a CloudFront distribution, S3 bucket, ELB, or Route 53 hosted zone. See `resource_elb.zone_id` for example.
     */
    @JvmName("hgqrvsxbajqxyano")
    public suspend fun zoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): RecordAliasArgs = RecordAliasArgs(
        evaluateTargetHealth = evaluateTargetHealth ?: throw
            PulumiNullFieldException("evaluateTargetHealth"),
        name = name ?: throw PulumiNullFieldException("name"),
        zoneId = zoneId ?: throw PulumiNullFieldException("zoneId"),
    )
}
