@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.RecordCidrRoutingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property collectionId The CIDR collection ID. See the `aws.route53.CidrCollection` resource for more details.
 * @property locationName The CIDR collection location name. See the `aws.route53.CidrLocation` resource for more details. A `location_name` with an asterisk `"*"` can be used to create a default CIDR record. `collection_id` is still required for default record.
 */
public data class RecordCidrRoutingPolicyArgs(
    public val collectionId: Output<String>,
    public val locationName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.RecordCidrRoutingPolicyArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.RecordCidrRoutingPolicyArgs =
        com.pulumi.aws.route53.inputs.RecordCidrRoutingPolicyArgs.builder()
            .collectionId(collectionId.applyValue({ args0 -> args0 }))
            .locationName(locationName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordCidrRoutingPolicyArgs].
 */
@PulumiTagMarker
public class RecordCidrRoutingPolicyArgsBuilder internal constructor() {
    private var collectionId: Output<String>? = null

    private var locationName: Output<String>? = null

    /**
     * @param value The CIDR collection ID. See the `aws.route53.CidrCollection` resource for more details.
     */
    @JvmName("ababeipqtejhuhrf")
    public suspend fun collectionId(`value`: Output<String>) {
        this.collectionId = value
    }

    /**
     * @param value The CIDR collection location name. See the `aws.route53.CidrLocation` resource for more details. A `location_name` with an asterisk `"*"` can be used to create a default CIDR record. `collection_id` is still required for default record.
     */
    @JvmName("qdcuonwdcvqtibvt")
    public suspend fun locationName(`value`: Output<String>) {
        this.locationName = value
    }

    /**
     * @param value The CIDR collection ID. See the `aws.route53.CidrCollection` resource for more details.
     */
    @JvmName("yuekhyobchgbilad")
    public suspend fun collectionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.collectionId = mapped
    }

    /**
     * @param value The CIDR collection location name. See the `aws.route53.CidrLocation` resource for more details. A `location_name` with an asterisk `"*"` can be used to create a default CIDR record. `collection_id` is still required for default record.
     */
    @JvmName("hcfxxefyjxggmyym")
    public suspend fun locationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locationName = mapped
    }

    internal fun build(): RecordCidrRoutingPolicyArgs = RecordCidrRoutingPolicyArgs(
        collectionId = collectionId ?: throw PulumiNullFieldException("collectionId"),
        locationName = locationName ?: throw PulumiNullFieldException("locationName"),
    )
}
