@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.RecordFailoverRoutingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type `PRIMARY` or `SECONDARY`. A `PRIMARY` record will be served if its healthcheck is passing, otherwise the `SECONDARY` will be served. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html#dns-failover-failover-rrsets
 */
public data class RecordFailoverRoutingPolicyArgs(
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.RecordFailoverRoutingPolicyArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.RecordFailoverRoutingPolicyArgs =
        com.pulumi.aws.route53.inputs.RecordFailoverRoutingPolicyArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordFailoverRoutingPolicyArgs].
 */
@PulumiTagMarker
public class RecordFailoverRoutingPolicyArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value `PRIMARY` or `SECONDARY`. A `PRIMARY` record will be served if its healthcheck is passing, otherwise the `SECONDARY` will be served. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html#dns-failover-failover-rrsets
     */
    @JvmName("wjyuaxehhdrwakhx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value `PRIMARY` or `SECONDARY`. A `PRIMARY` record will be served if its healthcheck is passing, otherwise the `SECONDARY` will be served. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html#dns-failover-failover-rrsets
     */
    @JvmName("ioqgkrvphbcwrstp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RecordFailoverRoutingPolicyArgs = RecordFailoverRoutingPolicyArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
