@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.RecordGeoproximityRoutingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property awsRegion A AWS region where the resource is present.
 * @property bias Route more traffic or less traffic to the resource by specifying a value ranges between -90 to 90. See https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-geoproximity.html for bias details.
 * @property coordinates Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
 * @property localZoneGroup A AWS local zone group where the resource is present. See https://docs.aws.amazon.com/local-zones/latest/ug/available-local-zones.html for local zone group list.
 */
public data class RecordGeoproximityRoutingPolicyArgs(
    public val awsRegion: Output<String>? = null,
    public val bias: Output<Int>? = null,
    public val coordinates: Output<List<RecordGeoproximityRoutingPolicyCoordinateArgs>>? = null,
    public val localZoneGroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.RecordGeoproximityRoutingPolicyArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.RecordGeoproximityRoutingPolicyArgs =
        com.pulumi.aws.route53.inputs.RecordGeoproximityRoutingPolicyArgs.builder()
            .awsRegion(awsRegion?.applyValue({ args0 -> args0 }))
            .bias(bias?.applyValue({ args0 -> args0 }))
            .coordinates(
                coordinates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .localZoneGroup(localZoneGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordGeoproximityRoutingPolicyArgs].
 */
@PulumiTagMarker
public class RecordGeoproximityRoutingPolicyArgsBuilder internal constructor() {
    private var awsRegion: Output<String>? = null

    private var bias: Output<Int>? = null

    private var coordinates: Output<List<RecordGeoproximityRoutingPolicyCoordinateArgs>>? = null

    private var localZoneGroup: Output<String>? = null

    /**
     * @param value A AWS region where the resource is present.
     */
    @JvmName("mckpmgictarhvvtk")
    public suspend fun awsRegion(`value`: Output<String>) {
        this.awsRegion = value
    }

    /**
     * @param value Route more traffic or less traffic to the resource by specifying a value ranges between -90 to 90. See https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-geoproximity.html for bias details.
     */
    @JvmName("btugrjpkrbglwbbi")
    public suspend fun bias(`value`: Output<Int>) {
        this.bias = value
    }

    /**
     * @param value Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
     */
    @JvmName("wnsyvipkvajuagpb")
    public suspend fun coordinates(`value`: Output<List<RecordGeoproximityRoutingPolicyCoordinateArgs>>) {
        this.coordinates = value
    }

    @JvmName("mxrnhtgieowsgxte")
    public suspend fun coordinates(vararg values: Output<RecordGeoproximityRoutingPolicyCoordinateArgs>) {
        this.coordinates = Output.all(values.asList())
    }

    /**
     * @param values Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
     */
    @JvmName("hwjiyasrxxfmiusy")
    public suspend fun coordinates(values: List<Output<RecordGeoproximityRoutingPolicyCoordinateArgs>>) {
        this.coordinates = Output.all(values)
    }

    /**
     * @param value A AWS local zone group where the resource is present. See https://docs.aws.amazon.com/local-zones/latest/ug/available-local-zones.html for local zone group list.
     */
    @JvmName("lfrxjklcvrteneks")
    public suspend fun localZoneGroup(`value`: Output<String>) {
        this.localZoneGroup = value
    }

    /**
     * @param value A AWS region where the resource is present.
     */
    @JvmName("xplfavsukrbjcvay")
    public suspend fun awsRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsRegion = mapped
    }

    /**
     * @param value Route more traffic or less traffic to the resource by specifying a value ranges between -90 to 90. See https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-geoproximity.html for bias details.
     */
    @JvmName("aglyuinqdxdhjhgj")
    public suspend fun bias(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bias = mapped
    }

    /**
     * @param value Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
     */
    @JvmName("ttaegrafbrsyhjtp")
    public suspend fun coordinates(`value`: List<RecordGeoproximityRoutingPolicyCoordinateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coordinates = mapped
    }

    /**
     * @param argument Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
     */
    @JvmName("tdxvnxacljjtespp")
    public suspend fun coordinates(argument: List<suspend RecordGeoproximityRoutingPolicyCoordinateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecordGeoproximityRoutingPolicyCoordinateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.coordinates = mapped
    }

    /**
     * @param argument Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
     */
    @JvmName("ksdghmvhjkavlsng")
    public suspend fun coordinates(vararg argument: suspend RecordGeoproximityRoutingPolicyCoordinateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RecordGeoproximityRoutingPolicyCoordinateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.coordinates = mapped
    }

    /**
     * @param argument Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
     */
    @JvmName("howdpgodjwxmumud")
    public suspend fun coordinates(argument: suspend RecordGeoproximityRoutingPolicyCoordinateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecordGeoproximityRoutingPolicyCoordinateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.coordinates = mapped
    }

    /**
     * @param values Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
     */
    @JvmName("svnntjdyqupmjsuu")
    public suspend fun coordinates(vararg values: RecordGeoproximityRoutingPolicyCoordinateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.coordinates = mapped
    }

    /**
     * @param value A AWS local zone group where the resource is present. See https://docs.aws.amazon.com/local-zones/latest/ug/available-local-zones.html for local zone group list.
     */
    @JvmName("egicdpvispydxpin")
    public suspend fun localZoneGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localZoneGroup = mapped
    }

    internal fun build(): RecordGeoproximityRoutingPolicyArgs = RecordGeoproximityRoutingPolicyArgs(
        awsRegion = awsRegion,
        bias = bias,
        coordinates = coordinates,
        localZoneGroup = localZoneGroup,
    )
}
