@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.RecordGeoproximityRoutingPolicyCoordinateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property latitude
 * @property longitude
 */
public data class RecordGeoproximityRoutingPolicyCoordinateArgs(
    public val latitude: Output<String>,
    public val longitude: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.RecordGeoproximityRoutingPolicyCoordinateArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.RecordGeoproximityRoutingPolicyCoordinateArgs = com.pulumi.aws.route53.inputs.RecordGeoproximityRoutingPolicyCoordinateArgs.builder()
        .latitude(latitude.applyValue({ args0 -> args0 }))
        .longitude(longitude.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordGeoproximityRoutingPolicyCoordinateArgs].
 */
@PulumiTagMarker
public class RecordGeoproximityRoutingPolicyCoordinateArgsBuilder internal constructor() {
    private var latitude: Output<String>? = null

    private var longitude: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("dgyghrbvwosoaora")
    public suspend fun latitude(`value`: Output<String>) {
        this.latitude = value
    }

    /**
     * @param value
     */
    @JvmName("wbyrpyphubbcscfy")
    public suspend fun longitude(`value`: Output<String>) {
        this.longitude = value
    }

    /**
     * @param value
     */
    @JvmName("snxnijpilkvoumaq")
    public suspend fun latitude(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.latitude = mapped
    }

    /**
     * @param value
     */
    @JvmName("rybscbhcnkmtiwnt")
    public suspend fun longitude(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.longitude = mapped
    }

    internal fun build(): RecordGeoproximityRoutingPolicyCoordinateArgs =
        RecordGeoproximityRoutingPolicyCoordinateArgs(
            latitude = latitude ?: throw PulumiNullFieldException("latitude"),
            longitude = longitude ?: throw PulumiNullFieldException("longitude"),
        )
}
