@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.RecordLatencyRoutingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property region An AWS region from which to measure latency. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-latency
 */
public data class RecordLatencyRoutingPolicyArgs(
    public val region: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.RecordLatencyRoutingPolicyArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.RecordLatencyRoutingPolicyArgs =
        com.pulumi.aws.route53.inputs.RecordLatencyRoutingPolicyArgs.builder()
            .region(region.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordLatencyRoutingPolicyArgs].
 */
@PulumiTagMarker
public class RecordLatencyRoutingPolicyArgsBuilder internal constructor() {
    private var region: Output<String>? = null

    /**
     * @param value An AWS region from which to measure latency. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-latency
     */
    @JvmName("hctpxcqawwavpeuk")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value An AWS region from which to measure latency. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-latency
     */
    @JvmName("tuyxmfqibuodsjtl")
    public suspend fun region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.region = mapped
    }

    internal fun build(): RecordLatencyRoutingPolicyArgs = RecordLatencyRoutingPolicyArgs(
        region = region ?: throw PulumiNullFieldException("region"),
    )
}
