@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.RecordWeightedRoutingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property weight A numeric value indicating the relative weight of the record. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted.
 */
public data class RecordWeightedRoutingPolicyArgs(
    public val weight: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.RecordWeightedRoutingPolicyArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.RecordWeightedRoutingPolicyArgs =
        com.pulumi.aws.route53.inputs.RecordWeightedRoutingPolicyArgs.builder()
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordWeightedRoutingPolicyArgs].
 */
@PulumiTagMarker
public class RecordWeightedRoutingPolicyArgsBuilder internal constructor() {
    private var weight: Output<Int>? = null

    /**
     * @param value A numeric value indicating the relative weight of the record. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted.
     */
    @JvmName("bgfdndbfdjxshgxs")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value A numeric value indicating the relative weight of the record. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted.
     */
    @JvmName("najkhtbhwghyuhmp")
    public suspend fun weight(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): RecordWeightedRoutingPolicyArgs = RecordWeightedRoutingPolicyArgs(
        weight = weight ?: throw PulumiNullFieldException("weight"),
    )
}
