@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.ResolverRuleTargetIpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ip One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
 * @property port The port at `ip` that you want to forward DNS queries to. Default value is `53`.
 * @property protocol The protocol for the resolver endpoint. Valid values can be found in the [AWS documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_TargetAddress.html). Default value is `Do53`.
 */
public data class ResolverRuleTargetIpArgs(
    public val ip: Output<String>,
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.ResolverRuleTargetIpArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.ResolverRuleTargetIpArgs =
        com.pulumi.aws.route53.inputs.ResolverRuleTargetIpArgs.builder()
            .ip(ip.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverRuleTargetIpArgs].
 */
@PulumiTagMarker
public class ResolverRuleTargetIpArgsBuilder internal constructor() {
    private var ip: Output<String>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
     */
    @JvmName("watdqbfcahfpespj")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value The port at `ip` that you want to forward DNS queries to. Default value is `53`.
     */
    @JvmName("cifnclfgqljsasaa")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The protocol for the resolver endpoint. Valid values can be found in the [AWS documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_TargetAddress.html). Default value is `Do53`.
     */
    @JvmName("tnafakylgbfukgjb")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
     */
    @JvmName("qmgbxtdmnmsgpcnr")
    public suspend fun ip(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param value The port at `ip` that you want to forward DNS queries to. Default value is `53`.
     */
    @JvmName("siynytwgowayphoq")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol for the resolver endpoint. Valid values can be found in the [AWS documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_TargetAddress.html). Default value is `Do53`.
     */
    @JvmName("xxhqujsicyqamftv")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): ResolverRuleTargetIpArgs = ResolverRuleTargetIpArgs(
        ip = ip ?: throw PulumiNullFieldException("ip"),
        port = port,
        protocol = protocol,
    )
}
