@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.ZoneVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property vpcId ID of the VPC to associate.
 * @property vpcRegion Region of the VPC to associate. Defaults to AWS provider region.
 */
public data class ZoneVpcArgs(
    public val vpcId: Output<String>,
    public val vpcRegion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.ZoneVpcArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.ZoneVpcArgs =
        com.pulumi.aws.route53.inputs.ZoneVpcArgs.builder()
            .vpcId(vpcId.applyValue({ args0 -> args0 }))
            .vpcRegion(vpcRegion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ZoneVpcArgs].
 */
@PulumiTagMarker
public class ZoneVpcArgsBuilder internal constructor() {
    private var vpcId: Output<String>? = null

    private var vpcRegion: Output<String>? = null

    /**
     * @param value ID of the VPC to associate.
     */
    @JvmName("jnwegforoeaugnon")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Region of the VPC to associate. Defaults to AWS provider region.
     */
    @JvmName("ywedcyqhwmfaptjt")
    public suspend fun vpcRegion(`value`: Output<String>) {
        this.vpcRegion = value
    }

    /**
     * @param value ID of the VPC to associate.
     */
    @JvmName("tuqonlwhkbetucbe")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value Region of the VPC to associate. Defaults to AWS provider region.
     */
    @JvmName("fkcutokhmsanabrs")
    public suspend fun vpcRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcRegion = mapped
    }

    internal fun build(): ZoneVpcArgs = ZoneVpcArgs(
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
        vpcRegion = vpcRegion,
    )
}
