@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getResolverEndpoint.
 * @property arn
 * @property direction
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipAddresses
 * @property name
 * @property protocols
 * @property resolverEndpointId
 * @property resolverEndpointType
 * @property status
 * @property vpcId
 */
public data class GetResolverEndpointResult(
    public val arn: String,
    public val direction: String,
    public val filters: List<GetResolverEndpointFilter>? = null,
    public val id: String,
    public val ipAddresses: List<String>,
    public val name: String,
    public val protocols: List<String>,
    public val resolverEndpointId: String? = null,
    public val resolverEndpointType: String,
    public val status: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetResolverEndpointResult): GetResolverEndpointResult = GetResolverEndpointResult(
            arn = javaType.arn(),
            direction = javaType.direction(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.GetResolverEndpointFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
            name = javaType.name(),
            protocols = javaType.protocols().map({ args0 -> args0 }),
            resolverEndpointId = javaType.resolverEndpointId().map({ args0 -> args0 }).orElse(null),
            resolverEndpointType = javaType.resolverEndpointType(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
        )
    }
}
