@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list.
 * @property blockOverrideDnsType The DNS record's type.
 * @property blockOverrideDomain The custom DNS record to send back in response to the query.
 * @property blockOverrideTtl The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record.
 * @property blockResponse The way that you want DNS Firewall to block the request.
 * @property creationTime The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC).
 * @property creatorRequestId A unique string defined by you to identify the request.
 * @property firewallDomainListId The ID of the domain list that's used in the rule.
 * @property firewallRuleGroupId The unique identifier of the firewall rule group that you want to retrieve the rules for.
 * @property modificationTime The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time (UTC).
 * @property name The name of the rule.
 * @property priority The setting that determines the processing order of the rules in a rule group.
 */
public data class GetResolverFirewallRulesFirewallRule(
    public val action: String,
    public val blockOverrideDnsType: String,
    public val blockOverrideDomain: String,
    public val blockOverrideTtl: Int,
    public val blockResponse: String,
    public val creationTime: String,
    public val creatorRequestId: String,
    public val firewallDomainListId: String,
    public val firewallRuleGroupId: String,
    public val modificationTime: String,
    public val name: String,
    public val priority: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetResolverFirewallRulesFirewallRule): GetResolverFirewallRulesFirewallRule = GetResolverFirewallRulesFirewallRule(
            action = javaType.action(),
            blockOverrideDnsType = javaType.blockOverrideDnsType(),
            blockOverrideDomain = javaType.blockOverrideDomain(),
            blockOverrideTtl = javaType.blockOverrideTtl(),
            blockResponse = javaType.blockResponse(),
            creationTime = javaType.creationTime(),
            creatorRequestId = javaType.creatorRequestId(),
            firewallDomainListId = javaType.firewallDomainListId(),
            firewallRuleGroupId = javaType.firewallRuleGroupId(),
            modificationTime = javaType.modificationTime(),
            name = javaType.name(),
            priority = javaType.priority(),
        )
    }
}
