@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getResolverFirewallRules.
 * @property action
 * @property firewallRuleGroupId
 * @property firewallRules List with information about the firewall rules. See details below.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property priority
 */
public data class GetResolverFirewallRulesResult(
    public val action: String? = null,
    public val firewallRuleGroupId: String,
    public val firewallRules: List<GetResolverFirewallRulesFirewallRule>,
    public val id: String,
    public val priority: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetResolverFirewallRulesResult): GetResolverFirewallRulesResult = GetResolverFirewallRulesResult(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            firewallRuleGroupId = javaType.firewallRuleGroupId(),
            firewallRules = javaType.firewallRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.GetResolverFirewallRulesFirewallRule.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
        )
    }
}
