@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getResolverRule.
 * @property arn ARN (Amazon Resource Name) for the resolver rule.
 * @property domainName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property ownerId When a rule is shared with another AWS account, the account ID of the account that the rule is shared with.
 * @property resolverEndpointId
 * @property resolverRuleId
 * @property ruleType
 * @property shareStatus Whether the rules is shared and, if so, whether the current account is sharing the rule with another account, or another account is sharing the rule with the current account.
 * Values are `NOT_SHARED`, `SHARED_BY_ME` or `SHARED_WITH_ME`
 * @property tags Map of tags assigned to the resolver rule.
 */
public data class GetResolverRuleResult(
    public val arn: String,
    public val domainName: String,
    public val id: String,
    public val name: String,
    public val ownerId: String,
    public val resolverEndpointId: String,
    public val resolverRuleId: String,
    public val ruleType: String,
    public val shareStatus: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetResolverRuleResult): GetResolverRuleResult = GetResolverRuleResult(
            arn = javaType.arn(),
            domainName = javaType.domainName(),
            id = javaType.id(),
            name = javaType.name(),
            ownerId = javaType.ownerId(),
            resolverEndpointId = javaType.resolverEndpointId(),
            resolverRuleId = javaType.resolverRuleId(),
            ruleType = javaType.ruleType(),
            shareStatus = javaType.shareStatus(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
