@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getResolverRules.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property nameRegex
 * @property ownerId
 * @property resolverEndpointId
 * @property resolverRuleIds IDs of the matched resolver rules.
 * @property ruleType
 * @property shareStatus
 */
public data class GetResolverRulesResult(
    public val id: String,
    public val nameRegex: String? = null,
    public val ownerId: String? = null,
    public val resolverEndpointId: String? = null,
    public val resolverRuleIds: List<String>,
    public val ruleType: String? = null,
    public val shareStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetResolverRulesResult): GetResolverRulesResult = GetResolverRulesResult(
            id = javaType.id(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            ownerId = javaType.ownerId().map({ args0 -> args0 }).orElse(null),
            resolverEndpointId = javaType.resolverEndpointId().map({ args0 -> args0 }).orElse(null),
            resolverRuleIds = javaType.resolverRuleIds().map({ args0 -> args0 }),
            ruleType = javaType.ruleType().map({ args0 -> args0 }).orElse(null),
            shareStatus = javaType.shareStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
