@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bias Specify a value for `bias` if you want to route more traffic to an endpoint from nearby endpoints (positive values) or route less traffic to an endpoint (negative values).
 * @property endpointReference References to an endpoint.
 * @property evaluateTargetHealth Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
 * @property healthCheck If you want to associate a health check with the endpoint or rule.
 * @property latitude Represents the location south (negative) or north (positive) of the equator. Valid values are -90 degrees to 90 degrees.
 * @property longitude Represents the location west (negative) or east (positive) of the prime meridian. Valid values are -180 degrees to 180 degrees.
 * @property region If your endpoint is an AWS resource, specify the AWS Region that you created the resource in.
 * @property ruleReference References to a rule.
 */
public data class GetTrafficPolicyDocumentRuleGeoProximityLocation(
    public val bias: String? = null,
    public val endpointReference: String? = null,
    public val evaluateTargetHealth: Boolean? = null,
    public val healthCheck: String? = null,
    public val latitude: String? = null,
    public val longitude: String? = null,
    public val region: String? = null,
    public val ruleReference: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetTrafficPolicyDocumentRuleGeoProximityLocation): GetTrafficPolicyDocumentRuleGeoProximityLocation =
            GetTrafficPolicyDocumentRuleGeoProximityLocation(
                bias = javaType.bias().map({ args0 -> args0 }).orElse(null),
                endpointReference = javaType.endpointReference().map({ args0 -> args0 }).orElse(null),
                evaluateTargetHealth = javaType.evaluateTargetHealth().map({ args0 -> args0 }).orElse(null),
                healthCheck = javaType.healthCheck().map({ args0 -> args0 }).orElse(null),
                latitude = javaType.latitude().map({ args0 -> args0 }).orElse(null),
                longitude = javaType.longitude().map({ args0 -> args0 }).orElse(null),
                region = javaType.region().map({ args0 -> args0 }).orElse(null),
                ruleReference = javaType.ruleReference().map({ args0 -> args0 }).orElse(null),
            )
    }
}
