@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property continent A two-letter continent code. See http://docs.aws.amazon.com/Route53/latest/APIReference/API_GetGeoLocation.html for code details. Either `continent` or `country` must be specified.
 * @property country A two-character country code or `*` to indicate a default resource record set.
 * @property subdivision A subdivision code for a country.
 */
public data class RecordGeolocationRoutingPolicy(
    public val continent: String? = null,
    public val country: String? = null,
    public val subdivision: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.RecordGeolocationRoutingPolicy): RecordGeolocationRoutingPolicy = RecordGeolocationRoutingPolicy(
            continent = javaType.continent().map({ args0 -> args0 }).orElse(null),
            country = javaType.country().map({ args0 -> args0 }).orElse(null),
            subdivision = javaType.subdivision().map({ args0 -> args0 }).orElse(null),
        )
    }
}
