@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property awsRegion A AWS region where the resource is present.
 * @property bias Route more traffic or less traffic to the resource by specifying a value ranges between -90 to 90. See https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-geoproximity.html for bias details.
 * @property coordinates Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
 * @property localZoneGroup A AWS local zone group where the resource is present. See https://docs.aws.amazon.com/local-zones/latest/ug/available-local-zones.html for local zone group list.
 */
public data class RecordGeoproximityRoutingPolicy(
    public val awsRegion: String? = null,
    public val bias: Int? = null,
    public val coordinates: List<RecordGeoproximityRoutingPolicyCoordinate>? = null,
    public val localZoneGroup: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.RecordGeoproximityRoutingPolicy): RecordGeoproximityRoutingPolicy = RecordGeoproximityRoutingPolicy(
            awsRegion = javaType.awsRegion().map({ args0 -> args0 }).orElse(null),
            bias = javaType.bias().map({ args0 -> args0 }).orElse(null),
            coordinates = javaType.coordinates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.RecordGeoproximityRoutingPolicyCoordinate.Companion.toKotlin(args0)
                })
            }),
            localZoneGroup = javaType.localZoneGroup().map({ args0 -> args0 }).orElse(null),
        )
    }
}
