@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ip One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
 * @property port The port at `ip` that you want to forward DNS queries to. Default value is `53`.
 * @property protocol The protocol for the resolver endpoint. Valid values can be found in the [AWS documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_TargetAddress.html). Default value is `Do53`.
 */
public data class ResolverRuleTargetIp(
    public val ip: String,
    public val port: Int? = null,
    public val protocol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.ResolverRuleTargetIp): ResolverRuleTargetIp = ResolverRuleTargetIp(
            ip = javaType.ip(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
