@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property vpcId ID of the VPC to associate.
 * @property vpcRegion Region of the VPC to associate. Defaults to AWS provider region.
 */
public data class ZoneVpc(
    public val vpcId: String,
    public val vpcRegion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.ZoneVpc): ZoneVpc = ZoneVpc(
            vpcId = javaType.vpcId(),
            vpcRegion = javaType.vpcRegion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
