@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53domains.kotlin

import com.pulumi.aws.route53domains.kotlin.outputs.RegisteredDomainAdminContact
import com.pulumi.aws.route53domains.kotlin.outputs.RegisteredDomainBillingContact
import com.pulumi.aws.route53domains.kotlin.outputs.RegisteredDomainNameServer
import com.pulumi.aws.route53domains.kotlin.outputs.RegisteredDomainRegistrantContact
import com.pulumi.aws.route53domains.kotlin.outputs.RegisteredDomainTechContact
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.route53domains.kotlin.outputs.RegisteredDomainAdminContact.Companion.toKotlin as registeredDomainAdminContactToKotlin
import com.pulumi.aws.route53domains.kotlin.outputs.RegisteredDomainBillingContact.Companion.toKotlin as registeredDomainBillingContactToKotlin
import com.pulumi.aws.route53domains.kotlin.outputs.RegisteredDomainNameServer.Companion.toKotlin as registeredDomainNameServerToKotlin
import com.pulumi.aws.route53domains.kotlin.outputs.RegisteredDomainRegistrantContact.Companion.toKotlin as registeredDomainRegistrantContactToKotlin
import com.pulumi.aws.route53domains.kotlin.outputs.RegisteredDomainTechContact.Companion.toKotlin as registeredDomainTechContactToKotlin

/**
 * Builder for [RegisteredDomain].
 */
@PulumiTagMarker
public class RegisteredDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegisteredDomainArgs = RegisteredDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegisteredDomainArgsBuilder.() -> Unit) {
        val builder = RegisteredDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegisteredDomain {
        val builtJavaResource = com.pulumi.aws.route53domains.RegisteredDomain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegisteredDomain(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a domain that has been [registered](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) and associated with the current AWS account.
 * **This is an advanced resource** and has special caveats to be aware of when using it. Please read this document in its entirety before using this resource.
 * The `aws.route53domains.RegisteredDomain` resource behaves differently from normal resources in that if a domain has been registered, the provider does not _register_ this domain, but instead "adopts" it into management. A destroy does not delete the domain but does remove the resource from state.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53domains.RegisteredDomain("example", {
 *     domainName: "example.com",
 *     nameServers: [
 *         {
 *             name: "ns-195.awsdns-24.com",
 *         },
 *         {
 *             name: "ns-874.awsdns-45.net",
 *         },
 *     ],
 *     tags: {
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53domains.RegisteredDomain("example",
 *     domain_name="example.com",
 *     name_servers=[
 *         {
 *             "name": "ns-195.awsdns-24.com",
 *         },
 *         {
 *             "name": "ns-874.awsdns-45.net",
 *         },
 *     ],
 *     tags={
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53Domains.RegisteredDomain("example", new()
 *     {
 *         DomainName = "example.com",
 *         NameServers = new[]
 *         {
 *             new Aws.Route53Domains.Inputs.RegisteredDomainNameServerArgs
 *             {
 *                 Name = "ns-195.awsdns-24.com",
 *             },
 *             new Aws.Route53Domains.Inputs.RegisteredDomainNameServerArgs
 *             {
 *                 Name = "ns-874.awsdns-45.net",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53domains"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53domains.NewRegisteredDomain(ctx, "example", &route53domains.RegisteredDomainArgs{
 * 			DomainName: pulumi.String("example.com"),
 * 			NameServers: route53domains.RegisteredDomainNameServerArray{
 * 				&route53domains.RegisteredDomainNameServerArgs{
 * 					Name: pulumi.String("ns-195.awsdns-24.com"),
 * 				},
 * 				&route53domains.RegisteredDomainNameServerArgs{
 * 					Name: pulumi.String("ns-874.awsdns-45.net"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53domains.RegisteredDomain;
 * import com.pulumi.aws.route53domains.RegisteredDomainArgs;
 * import com.pulumi.aws.route53domains.inputs.RegisteredDomainNameServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RegisteredDomain("example", RegisteredDomainArgs.builder()
 *             .domainName("example.com")
 *             .nameServers(
 *                 RegisteredDomainNameServerArgs.builder()
 *                     .name("ns-195.awsdns-24.com")
 *                     .build(),
 *                 RegisteredDomainNameServerArgs.builder()
 *                     .name("ns-874.awsdns-45.net")
 *                     .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53domains:RegisteredDomain
 *     properties:
 *       domainName: example.com
 *       nameServers:
 *         - name: ns-195.awsdns-24.com
 *         - name: ns-874.awsdns-45.net
 *       tags:
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import domains using the domain name. For example:
 * ```sh
 * $ pulumi import aws:route53domains/registeredDomain:RegisteredDomain example example.com
 * ```
 */
public class RegisteredDomain internal constructor(
    override val javaResource: com.pulumi.aws.route53domains.RegisteredDomain,
) : KotlinCustomResource(javaResource, RegisteredDomainMapper) {
    /**
     * Email address to contact to report incorrect contact information for a domain, to report that the domain is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
     */
    public val abuseContactEmail: Output<String>
        get() = javaResource.abuseContactEmail().applyValue({ args0 -> args0 })

    /**
     * Phone number for reporting abuse.
     */
    public val abuseContactPhone: Output<String>
        get() = javaResource.abuseContactPhone().applyValue({ args0 -> args0 })

    /**
     * Details about the domain administrative contact. See Contact Blocks for more details.
     */
    public val adminContact: Output<RegisteredDomainAdminContact>
        get() = javaResource.adminContact().applyValue({ args0 ->
            args0.let({ args0 ->
                registeredDomainAdminContactToKotlin(args0)
            })
        })

    /**
     * Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
     */
    public val adminPrivacy: Output<Boolean>?
        get() = javaResource.adminPrivacy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the domain registration is set to renew automatically. Default: `true`.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Details about the domain billing contact. See Contact Blocks for more details.
     */
    public val billingContact: Output<RegisteredDomainBillingContact>
        get() = javaResource.billingContact().applyValue({ args0 ->
            args0.let({ args0 ->
                registeredDomainBillingContactToKotlin(args0)
            })
        })

    /**
     * Whether domain billing contact information is concealed from WHOIS queries. Default: `true`.
     */
    public val billingPrivacy: Output<Boolean>?
        get() = javaResource.billingPrivacy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date when the domain was created as found in the response to a WHOIS query.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The name of the registered domain.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The date when the registration for the domain is set to expire.
     */
    public val expirationDate: Output<String>
        get() = javaResource.expirationDate().applyValue({ args0 -> args0 })

    /**
     * The list of nameservers for the domain. See `name_server` Blocks for more details.
     */
    public val nameServers: Output<List<RegisteredDomainNameServer>>
        get() = javaResource.nameServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    registeredDomainNameServerToKotlin(args0)
                })
            })
        })

    /**
     * Details about the domain registrant. See Contact Blocks for more details.
     */
    public val registrantContact: Output<RegisteredDomainRegistrantContact>
        get() = javaResource.registrantContact().applyValue({ args0 ->
            args0.let({ args0 ->
                registeredDomainRegistrantContactToKotlin(args0)
            })
        })

    /**
     * Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
     */
    public val registrantPrivacy: Output<Boolean>?
        get() = javaResource.registrantPrivacy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the registrar of the domain as identified in the registry.
     */
    public val registrarName: Output<String>
        get() = javaResource.registrarName().applyValue({ args0 -> args0 })

    /**
     * Web address of the registrar.
     */
    public val registrarUrl: Output<String>
        get() = javaResource.registrarUrl().applyValue({ args0 -> args0 })

    /**
     * Reseller of the domain.
     */
    public val reseller: Output<String>
        get() = javaResource.reseller().applyValue({ args0 -> args0 })

    /**
     * List of [domain name status codes](https://www.icann.org/resources/pages/epp-status-codes-2014-06-16-en).
     */
    public val statusLists: Output<List<String>>
        get() = javaResource.statusLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Details about the domain technical contact. See Contact Blocks for more details.
     */
    public val techContact: Output<RegisteredDomainTechContact>
        get() = javaResource.techContact().applyValue({ args0 ->
            args0.let({ args0 ->
                registeredDomainTechContactToKotlin(args0)
            })
        })

    /**
     * Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
     */
    public val techPrivacy: Output<Boolean>?
        get() = javaResource.techPrivacy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the domain is locked for transfer. Default: `true`.
     */
    public val transferLock: Output<Boolean>?
        get() = javaResource.transferLock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The last updated date of the domain as found in the response to a WHOIS query.
     */
    public val updatedDate: Output<String>
        get() = javaResource.updatedDate().applyValue({ args0 -> args0 })

    /**
     * The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
     */
    public val whoisServer: Output<String>
        get() = javaResource.whoisServer().applyValue({ args0 -> args0 })
}

public object RegisteredDomainMapper : ResourceMapper<RegisteredDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53domains.RegisteredDomain::class == javaResource::class

    override fun map(javaResource: Resource): RegisteredDomain = RegisteredDomain(
        javaResource as
            com.pulumi.aws.route53domains.RegisteredDomain,
    )
}

/**
 * @see [RegisteredDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegisteredDomain].
 */
public suspend fun registeredDomain(
    name: String,
    block: suspend RegisteredDomainResourceBuilder.() -> Unit,
): RegisteredDomain {
    val builder = RegisteredDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegisteredDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registeredDomain(name: String): RegisteredDomain {
    val builder = RegisteredDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
