@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53domains.kotlin

import com.pulumi.aws.route53domains.RegisteredDomainArgs.builder
import com.pulumi.aws.route53domains.kotlin.inputs.RegisteredDomainAdminContactArgs
import com.pulumi.aws.route53domains.kotlin.inputs.RegisteredDomainAdminContactArgsBuilder
import com.pulumi.aws.route53domains.kotlin.inputs.RegisteredDomainBillingContactArgs
import com.pulumi.aws.route53domains.kotlin.inputs.RegisteredDomainBillingContactArgsBuilder
import com.pulumi.aws.route53domains.kotlin.inputs.RegisteredDomainNameServerArgs
import com.pulumi.aws.route53domains.kotlin.inputs.RegisteredDomainNameServerArgsBuilder
import com.pulumi.aws.route53domains.kotlin.inputs.RegisteredDomainRegistrantContactArgs
import com.pulumi.aws.route53domains.kotlin.inputs.RegisteredDomainRegistrantContactArgsBuilder
import com.pulumi.aws.route53domains.kotlin.inputs.RegisteredDomainTechContactArgs
import com.pulumi.aws.route53domains.kotlin.inputs.RegisteredDomainTechContactArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a domain that has been [registered](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) and associated with the current AWS account.
 * **This is an advanced resource** and has special caveats to be aware of when using it. Please read this document in its entirety before using this resource.
 * The `aws.route53domains.RegisteredDomain` resource behaves differently from normal resources in that if a domain has been registered, the provider does not _register_ this domain, but instead "adopts" it into management. A destroy does not delete the domain but does remove the resource from state.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53domains.RegisteredDomain("example", {
 *     domainName: "example.com",
 *     nameServers: [
 *         {
 *             name: "ns-195.awsdns-24.com",
 *         },
 *         {
 *             name: "ns-874.awsdns-45.net",
 *         },
 *     ],
 *     tags: {
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53domains.RegisteredDomain("example",
 *     domain_name="example.com",
 *     name_servers=[
 *         {
 *             "name": "ns-195.awsdns-24.com",
 *         },
 *         {
 *             "name": "ns-874.awsdns-45.net",
 *         },
 *     ],
 *     tags={
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53Domains.RegisteredDomain("example", new()
 *     {
 *         DomainName = "example.com",
 *         NameServers = new[]
 *         {
 *             new Aws.Route53Domains.Inputs.RegisteredDomainNameServerArgs
 *             {
 *                 Name = "ns-195.awsdns-24.com",
 *             },
 *             new Aws.Route53Domains.Inputs.RegisteredDomainNameServerArgs
 *             {
 *                 Name = "ns-874.awsdns-45.net",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53domains"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53domains.NewRegisteredDomain(ctx, "example", &route53domains.RegisteredDomainArgs{
 * 			DomainName: pulumi.String("example.com"),
 * 			NameServers: route53domains.RegisteredDomainNameServerArray{
 * 				&route53domains.RegisteredDomainNameServerArgs{
 * 					Name: pulumi.String("ns-195.awsdns-24.com"),
 * 				},
 * 				&route53domains.RegisteredDomainNameServerArgs{
 * 					Name: pulumi.String("ns-874.awsdns-45.net"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53domains.RegisteredDomain;
 * import com.pulumi.aws.route53domains.RegisteredDomainArgs;
 * import com.pulumi.aws.route53domains.inputs.RegisteredDomainNameServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RegisteredDomain("example", RegisteredDomainArgs.builder()
 *             .domainName("example.com")
 *             .nameServers(
 *                 RegisteredDomainNameServerArgs.builder()
 *                     .name("ns-195.awsdns-24.com")
 *                     .build(),
 *                 RegisteredDomainNameServerArgs.builder()
 *                     .name("ns-874.awsdns-45.net")
 *                     .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53domains:RegisteredDomain
 *     properties:
 *       domainName: example.com
 *       nameServers:
 *         - name: ns-195.awsdns-24.com
 *         - name: ns-874.awsdns-45.net
 *       tags:
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import domains using the domain name. For example:
 * ```sh
 * $ pulumi import aws:route53domains/registeredDomain:RegisteredDomain example example.com
 * ```
 * @property adminContact Details about the domain administrative contact. See Contact Blocks for more details.
 * @property adminPrivacy Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
 * @property autoRenew Whether the domain registration is set to renew automatically. Default: `true`.
 * @property billingContact Details about the domain billing contact. See Contact Blocks for more details.
 * @property billingPrivacy Whether domain billing contact information is concealed from WHOIS queries. Default: `true`.
 * @property domainName The name of the registered domain.
 * @property nameServers The list of nameservers for the domain. See `name_server` Blocks for more details.
 * @property registrantContact Details about the domain registrant. See Contact Blocks for more details.
 * @property registrantPrivacy Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property techContact Details about the domain technical contact. See Contact Blocks for more details.
 * @property techPrivacy Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
 * @property transferLock Whether the domain is locked for transfer. Default: `true`.
 */
public data class RegisteredDomainArgs(
    public val adminContact: Output<RegisteredDomainAdminContactArgs>? = null,
    public val adminPrivacy: Output<Boolean>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val billingContact: Output<RegisteredDomainBillingContactArgs>? = null,
    public val billingPrivacy: Output<Boolean>? = null,
    public val domainName: Output<String>? = null,
    public val nameServers: Output<List<RegisteredDomainNameServerArgs>>? = null,
    public val registrantContact: Output<RegisteredDomainRegistrantContactArgs>? = null,
    public val registrantPrivacy: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val techContact: Output<RegisteredDomainTechContactArgs>? = null,
    public val techPrivacy: Output<Boolean>? = null,
    public val transferLock: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53domains.RegisteredDomainArgs> {
    override fun toJava(): com.pulumi.aws.route53domains.RegisteredDomainArgs =
        com.pulumi.aws.route53domains.RegisteredDomainArgs.builder()
            .adminContact(adminContact?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .adminPrivacy(adminPrivacy?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .billingContact(billingContact?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .billingPrivacy(billingPrivacy?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .nameServers(
                nameServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .registrantContact(registrantContact?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registrantPrivacy(registrantPrivacy?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .techContact(techContact?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .techPrivacy(techPrivacy?.applyValue({ args0 -> args0 }))
            .transferLock(transferLock?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegisteredDomainArgs].
 */
@PulumiTagMarker
public class RegisteredDomainArgsBuilder internal constructor() {
    private var adminContact: Output<RegisteredDomainAdminContactArgs>? = null

    private var adminPrivacy: Output<Boolean>? = null

    private var autoRenew: Output<Boolean>? = null

    private var billingContact: Output<RegisteredDomainBillingContactArgs>? = null

    private var billingPrivacy: Output<Boolean>? = null

    private var domainName: Output<String>? = null

    private var nameServers: Output<List<RegisteredDomainNameServerArgs>>? = null

    private var registrantContact: Output<RegisteredDomainRegistrantContactArgs>? = null

    private var registrantPrivacy: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var techContact: Output<RegisteredDomainTechContactArgs>? = null

    private var techPrivacy: Output<Boolean>? = null

    private var transferLock: Output<Boolean>? = null

    /**
     * @param value Details about the domain administrative contact. See Contact Blocks for more details.
     */
    @JvmName("hitwweaknjpjxins")
    public suspend fun adminContact(`value`: Output<RegisteredDomainAdminContactArgs>) {
        this.adminContact = value
    }

    /**
     * @param value Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
     */
    @JvmName("yonsqragvplwqumd")
    public suspend fun adminPrivacy(`value`: Output<Boolean>) {
        this.adminPrivacy = value
    }

    /**
     * @param value Whether the domain registration is set to renew automatically. Default: `true`.
     */
    @JvmName("bubbmvncfnmxydxl")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Details about the domain billing contact. See Contact Blocks for more details.
     */
    @JvmName("dpjahtaqjdnunwcl")
    public suspend fun billingContact(`value`: Output<RegisteredDomainBillingContactArgs>) {
        this.billingContact = value
    }

    /**
     * @param value Whether domain billing contact information is concealed from WHOIS queries. Default: `true`.
     */
    @JvmName("kianmpywgjujwoyc")
    public suspend fun billingPrivacy(`value`: Output<Boolean>) {
        this.billingPrivacy = value
    }

    /**
     * @param value The name of the registered domain.
     */
    @JvmName("frbeiarwvwbecill")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The list of nameservers for the domain. See `name_server` Blocks for more details.
     */
    @JvmName("sdkenoxooheambjl")
    public suspend fun nameServers(`value`: Output<List<RegisteredDomainNameServerArgs>>) {
        this.nameServers = value
    }

    @JvmName("fcnycrxognhyopvf")
    public suspend fun nameServers(vararg values: Output<RegisteredDomainNameServerArgs>) {
        this.nameServers = Output.all(values.asList())
    }

    /**
     * @param values The list of nameservers for the domain. See `name_server` Blocks for more details.
     */
    @JvmName("vuebymauqwjlxkjb")
    public suspend fun nameServers(values: List<Output<RegisteredDomainNameServerArgs>>) {
        this.nameServers = Output.all(values)
    }

    /**
     * @param value Details about the domain registrant. See Contact Blocks for more details.
     */
    @JvmName("alpbtvurbcuyslsm")
    public suspend fun registrantContact(`value`: Output<RegisteredDomainRegistrantContactArgs>) {
        this.registrantContact = value
    }

    /**
     * @param value Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
     */
    @JvmName("vqgnmtvuecajgyvg")
    public suspend fun registrantPrivacy(`value`: Output<Boolean>) {
        this.registrantPrivacy = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("getrnameisiumfhc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Details about the domain technical contact. See Contact Blocks for more details.
     */
    @JvmName("osfyeygvcdrbbvtb")
    public suspend fun techContact(`value`: Output<RegisteredDomainTechContactArgs>) {
        this.techContact = value
    }

    /**
     * @param value Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
     */
    @JvmName("sknywoqctmpxsiho")
    public suspend fun techPrivacy(`value`: Output<Boolean>) {
        this.techPrivacy = value
    }

    /**
     * @param value Whether the domain is locked for transfer. Default: `true`.
     */
    @JvmName("lieqlmvuxxolordr")
    public suspend fun transferLock(`value`: Output<Boolean>) {
        this.transferLock = value
    }

    /**
     * @param value Details about the domain administrative contact. See Contact Blocks for more details.
     */
    @JvmName("lsmqbtlnismqeoln")
    public suspend fun adminContact(`value`: RegisteredDomainAdminContactArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminContact = mapped
    }

    /**
     * @param argument Details about the domain administrative contact. See Contact Blocks for more details.
     */
    @JvmName("dvnttcanhxsppfie")
    public suspend fun adminContact(argument: suspend RegisteredDomainAdminContactArgsBuilder.() -> Unit) {
        val toBeMapped = RegisteredDomainAdminContactArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.adminContact = mapped
    }

    /**
     * @param value Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
     */
    @JvmName("igthkbgsoagkvxwq")
    public suspend fun adminPrivacy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPrivacy = mapped
    }

    /**
     * @param value Whether the domain registration is set to renew automatically. Default: `true`.
     */
    @JvmName("nofgfgpptwvgasxt")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Details about the domain billing contact. See Contact Blocks for more details.
     */
    @JvmName("yhkpgicpchxklpru")
    public suspend fun billingContact(`value`: RegisteredDomainBillingContactArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingContact = mapped
    }

    /**
     * @param argument Details about the domain billing contact. See Contact Blocks for more details.
     */
    @JvmName("kaofjgfdbmqavopu")
    public suspend fun billingContact(argument: suspend RegisteredDomainBillingContactArgsBuilder.() -> Unit) {
        val toBeMapped = RegisteredDomainBillingContactArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.billingContact = mapped
    }

    /**
     * @param value Whether domain billing contact information is concealed from WHOIS queries. Default: `true`.
     */
    @JvmName("boklpetirwcusaja")
    public suspend fun billingPrivacy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingPrivacy = mapped
    }

    /**
     * @param value The name of the registered domain.
     */
    @JvmName("amghqwahhigowsfq")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The list of nameservers for the domain. See `name_server` Blocks for more details.
     */
    @JvmName("vdflnueyggvxmvor")
    public suspend fun nameServers(`value`: List<RegisteredDomainNameServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameServers = mapped
    }

    /**
     * @param argument The list of nameservers for the domain. See `name_server` Blocks for more details.
     */
    @JvmName("gahhmtopuuhonsat")
    public suspend fun nameServers(argument: List<suspend RegisteredDomainNameServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegisteredDomainNameServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nameServers = mapped
    }

    /**
     * @param argument The list of nameservers for the domain. See `name_server` Blocks for more details.
     */
    @JvmName("gdouawqodpufkujc")
    public suspend fun nameServers(vararg argument: suspend RegisteredDomainNameServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RegisteredDomainNameServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nameServers = mapped
    }

    /**
     * @param argument The list of nameservers for the domain. See `name_server` Blocks for more details.
     */
    @JvmName("bkahjeyvnhwostdb")
    public suspend fun nameServers(argument: suspend RegisteredDomainNameServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RegisteredDomainNameServerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.nameServers = mapped
    }

    /**
     * @param values The list of nameservers for the domain. See `name_server` Blocks for more details.
     */
    @JvmName("ooauapnpogbvytdg")
    public suspend fun nameServers(vararg values: RegisteredDomainNameServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameServers = mapped
    }

    /**
     * @param value Details about the domain registrant. See Contact Blocks for more details.
     */
    @JvmName("kpfmtgvnjiynqsjk")
    public suspend fun registrantContact(`value`: RegisteredDomainRegistrantContactArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrantContact = mapped
    }

    /**
     * @param argument Details about the domain registrant. See Contact Blocks for more details.
     */
    @JvmName("fkbpixevnheevlic")
    public suspend fun registrantContact(argument: suspend RegisteredDomainRegistrantContactArgsBuilder.() -> Unit) {
        val toBeMapped = RegisteredDomainRegistrantContactArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.registrantContact = mapped
    }

    /**
     * @param value Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
     */
    @JvmName("uhefatgprqcqsoac")
    public suspend fun registrantPrivacy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrantPrivacy = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("odnqlqgrnqkufwlw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mgdiukisdvednkha")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Details about the domain technical contact. See Contact Blocks for more details.
     */
    @JvmName("lujaeysdjghjnwjy")
    public suspend fun techContact(`value`: RegisteredDomainTechContactArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.techContact = mapped
    }

    /**
     * @param argument Details about the domain technical contact. See Contact Blocks for more details.
     */
    @JvmName("lkmbymllopewwhes")
    public suspend fun techContact(argument: suspend RegisteredDomainTechContactArgsBuilder.() -> Unit) {
        val toBeMapped = RegisteredDomainTechContactArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.techContact = mapped
    }

    /**
     * @param value Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
     */
    @JvmName("jdwqtedrbknevruq")
    public suspend fun techPrivacy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.techPrivacy = mapped
    }

    /**
     * @param value Whether the domain is locked for transfer. Default: `true`.
     */
    @JvmName("toawtacgcjbuaise")
    public suspend fun transferLock(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transferLock = mapped
    }

    internal fun build(): RegisteredDomainArgs = RegisteredDomainArgs(
        adminContact = adminContact,
        adminPrivacy = adminPrivacy,
        autoRenew = autoRenew,
        billingContact = billingContact,
        billingPrivacy = billingPrivacy,
        domainName = domainName,
        nameServers = nameServers,
        registrantContact = registrantContact,
        registrantPrivacy = registrantPrivacy,
        tags = tags,
        techContact = techContact,
        techPrivacy = techPrivacy,
        transferLock = transferLock,
    )
}
