@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53domains.kotlin.inputs

import com.pulumi.aws.route53domains.inputs.DelegationSignerRecordSigningAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property algorithm Algorithm which was used to generate the digest from the public key.
 * @property flags Defines the type of key. It can be either a KSK (key-signing-key, value `257`) or ZSK (zone-signing-key, value `256`).
 * @property publicKey The base64-encoded public key part of the key pair that is passed to the registry.
 */
public data class DelegationSignerRecordSigningAttributesArgs(
    public val algorithm: Output<Int>,
    public val flags: Output<Int>,
    public val publicKey: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.route53domains.inputs.DelegationSignerRecordSigningAttributesArgs> {
    override fun toJava(): com.pulumi.aws.route53domains.inputs.DelegationSignerRecordSigningAttributesArgs =
        com.pulumi.aws.route53domains.inputs.DelegationSignerRecordSigningAttributesArgs.builder()
            .algorithm(algorithm.applyValue({ args0 -> args0 }))
            .flags(flags.applyValue({ args0 -> args0 }))
            .publicKey(publicKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DelegationSignerRecordSigningAttributesArgs].
 */
@PulumiTagMarker
public class DelegationSignerRecordSigningAttributesArgsBuilder internal constructor() {
    private var algorithm: Output<Int>? = null

    private var flags: Output<Int>? = null

    private var publicKey: Output<String>? = null

    /**
     * @param value Algorithm which was used to generate the digest from the public key.
     */
    @JvmName("mnsmclekjkcasexr")
    public suspend fun algorithm(`value`: Output<Int>) {
        this.algorithm = value
    }

    /**
     * @param value Defines the type of key. It can be either a KSK (key-signing-key, value `257`) or ZSK (zone-signing-key, value `256`).
     */
    @JvmName("fyxvobwkxgkwdayp")
    public suspend fun flags(`value`: Output<Int>) {
        this.flags = value
    }

    /**
     * @param value The base64-encoded public key part of the key pair that is passed to the registry.
     */
    @JvmName("yrjjxpofbcgdrjpi")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value Algorithm which was used to generate the digest from the public key.
     */
    @JvmName("xwmhworovxwcxkld")
    public suspend fun algorithm(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.algorithm = mapped
    }

    /**
     * @param value Defines the type of key. It can be either a KSK (key-signing-key, value `257`) or ZSK (zone-signing-key, value `256`).
     */
    @JvmName("ydbshldursjymfck")
    public suspend fun flags(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flags = mapped
    }

    /**
     * @param value The base64-encoded public key part of the key pair that is passed to the registry.
     */
    @JvmName("iaaegvvwuimrvskb")
    public suspend fun publicKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    internal fun build(): DelegationSignerRecordSigningAttributesArgs =
        DelegationSignerRecordSigningAttributesArgs(
            algorithm = algorithm ?: throw PulumiNullFieldException("algorithm"),
            flags = flags ?: throw PulumiNullFieldException("flags"),
            publicKey = publicKey ?: throw PulumiNullFieldException("publicKey"),
        )
}
