@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53domains.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property algorithm Algorithm which was used to generate the digest from the public key.
 * @property flags Defines the type of key. It can be either a KSK (key-signing-key, value `257`) or ZSK (zone-signing-key, value `256`).
 * @property publicKey The base64-encoded public key part of the key pair that is passed to the registry.
 */
public data class DelegationSignerRecordSigningAttributes(
    public val algorithm: Int,
    public val flags: Int,
    public val publicKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53domains.outputs.DelegationSignerRecordSigningAttributes): DelegationSignerRecordSigningAttributes = DelegationSignerRecordSigningAttributes(
            algorithm = javaType.algorithm(),
            flags = javaType.flags(),
            publicKey = javaType.publicKey(),
        )
    }
}
