@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53domains.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property glueIps Glue IP addresses of a name server. The list can contain only one IPv4 and one IPv6 address.
 * @property name The fully qualified host name of the name server.
 */
public data class RegisteredDomainNameServer(
    public val glueIps: List<String>? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53domains.outputs.RegisteredDomainNameServer): RegisteredDomainNameServer = RegisteredDomainNameServer(
            glueIps = javaType.glueIps().map({ args0 -> args0 }),
            name = javaType.name(),
        )
    }
}
