@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoverycontrol.kotlin

import com.pulumi.aws.route53recoverycontrol.ClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AWS Route 53 Recovery Control Config Cluster.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53recoverycontrol.Cluster("example", {name: "georgefitzgerald"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53recoverycontrol.Cluster("example", name="georgefitzgerald")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53RecoveryControl.Cluster("example", new()
 *     {
 *         Name = "georgefitzgerald",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53recoverycontrol"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53recoverycontrol.NewCluster(ctx, "example", &route53recoverycontrol.ClusterArgs{
 * 			Name: pulumi.String("georgefitzgerald"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoverycontrol.Cluster;
 * import com.pulumi.aws.route53recoverycontrol.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .name("georgefitzgerald")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53recoverycontrol:Cluster
 *     properties:
 *       name: georgefitzgerald
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Control Config cluster using the cluster ARN. For example:
 * ```sh
 * $ pulumi import aws:route53recoverycontrol/cluster:Cluster mycluster arn:aws:route53-recovery-control::313517334327:cluster/f9ae13be-a11e-4ec7-8522-94a70468e6ea
 * ```
 * @property name Unique name describing the cluster.
 */
public data class ClusterArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53recoverycontrol.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.route53recoverycontrol.ClusterArgs =
        com.pulumi.aws.route53recoverycontrol.ClusterArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Unique name describing the cluster.
     */
    @JvmName("lxaixtsytuplgioc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Unique name describing the cluster.
     */
    @JvmName("vxxbticqoqtpaqkp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        name = name,
    )
}
