@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoverycontrol.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property inverted Logical negation of the rule.
 * @property threshold Number of controls that must be set when you specify an `ATLEAST` type rule.
 * @property type Rule type. Valid values are `ATLEAST`, `AND`, and `OR`.
 */
public data class SafetyRuleRuleConfig(
    public val inverted: Boolean,
    public val threshold: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53recoverycontrol.outputs.SafetyRuleRuleConfig): SafetyRuleRuleConfig = SafetyRuleRuleConfig(
            inverted = javaType.inverted(),
            threshold = javaType.threshold(),
            type = javaType.type(),
        )
    }
}
