@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin

import com.pulumi.aws.route53recoveryreadiness.CellArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Route 53 Recovery Readiness Cell.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53recoveryreadiness.Cell("example", {cellName: "us-west-2-failover-cell"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53recoveryreadiness.Cell("example", cell_name="us-west-2-failover-cell")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53RecoveryReadiness.Cell("example", new()
 *     {
 *         CellName = "us-west-2-failover-cell",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53recoveryreadiness"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53recoveryreadiness.NewCell(ctx, "example", &route53recoveryreadiness.CellArgs{
 * 			CellName: pulumi.String("us-west-2-failover-cell"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoveryreadiness.Cell;
 * import com.pulumi.aws.route53recoveryreadiness.CellArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cell("example", CellArgs.builder()
 *             .cellName("us-west-2-failover-cell")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53recoveryreadiness:Cell
 *     properties:
 *       cellName: us-west-2-failover-cell
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Readiness cells using the cell name. For example:
 * ```sh
 * $ pulumi import aws:route53recoveryreadiness/cell:Cell us-west-2-failover-cell us-west-2-failover-cell
 * ```
 * @property cellName Unique name describing the cell.
 * The following arguments are optional:
 * @property cells List of cell arns to add as nested fault domains within this cell.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class CellArgs(
    public val cellName: Output<String>? = null,
    public val cells: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53recoveryreadiness.CellArgs> {
    override fun toJava(): com.pulumi.aws.route53recoveryreadiness.CellArgs =
        com.pulumi.aws.route53recoveryreadiness.CellArgs.builder()
            .cellName(cellName?.applyValue({ args0 -> args0 }))
            .cells(cells?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CellArgs].
 */
@PulumiTagMarker
public class CellArgsBuilder internal constructor() {
    private var cellName: Output<String>? = null

    private var cells: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Unique name describing the cell.
     * The following arguments are optional:
     */
    @JvmName("qlcxahowguqckdro")
    public suspend fun cellName(`value`: Output<String>) {
        this.cellName = value
    }

    /**
     * @param value List of cell arns to add as nested fault domains within this cell.
     */
    @JvmName("euhhchhfqbkanakf")
    public suspend fun cells(`value`: Output<List<String>>) {
        this.cells = value
    }

    @JvmName("ugjqgpdklawqtatv")
    public suspend fun cells(vararg values: Output<String>) {
        this.cells = Output.all(values.asList())
    }

    /**
     * @param values List of cell arns to add as nested fault domains within this cell.
     */
    @JvmName("qsqvtyhvknwikrjm")
    public suspend fun cells(values: List<Output<String>>) {
        this.cells = Output.all(values)
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("mxjpuyxsfrndobdq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Unique name describing the cell.
     * The following arguments are optional:
     */
    @JvmName("nmykqlsjxtlpfidw")
    public suspend fun cellName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cellName = mapped
    }

    /**
     * @param value List of cell arns to add as nested fault domains within this cell.
     */
    @JvmName("kuffowoyarbavgrw")
    public suspend fun cells(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cells = mapped
    }

    /**
     * @param values List of cell arns to add as nested fault domains within this cell.
     */
    @JvmName("jhpvhgogwkthuqaq")
    public suspend fun cells(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cells = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("iaefxhahtxnmjxog")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("jgcsmnnsrblvdwmp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CellArgs = CellArgs(
        cellName = cellName,
        cells = cells,
        tags = tags,
    )
}
