@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin

import com.pulumi.aws.route53recoveryreadiness.ReadinessCheckArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Route 53 Recovery Readiness Readiness Check.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53recoveryreadiness.ReadinessCheck("example", {
 *     readinessCheckName: my_cw_alarm_check,
 *     resourceSetName: my_cw_alarm_set,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53recoveryreadiness.ReadinessCheck("example",
 *     readiness_check_name=my_cw_alarm_check,
 *     resource_set_name=my_cw_alarm_set)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53RecoveryReadiness.ReadinessCheck("example", new()
 *     {
 *         ReadinessCheckName = my_cw_alarm_check,
 *         ResourceSetName = my_cw_alarm_set,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53recoveryreadiness"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53recoveryreadiness.NewReadinessCheck(ctx, "example", &route53recoveryreadiness.ReadinessCheckArgs{
 * 			ReadinessCheckName: pulumi.Any(my_cw_alarm_check),
 * 			ResourceSetName:    pulumi.Any(my_cw_alarm_set),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoveryreadiness.ReadinessCheck;
 * import com.pulumi.aws.route53recoveryreadiness.ReadinessCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ReadinessCheck("example", ReadinessCheckArgs.builder()
 *             .readinessCheckName(my_cw_alarm_check)
 *             .resourceSetName(my_cw_alarm_set)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53recoveryreadiness:ReadinessCheck
 *     properties:
 *       readinessCheckName: ${["my-cw-alarm-check"]}
 *       resourceSetName: ${["my-cw-alarm-set"]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Readiness readiness checks using the readiness check name. For example:
 * ```sh
 * $ pulumi import aws:route53recoveryreadiness/readinessCheck:ReadinessCheck my-cw-alarm-check example
 * ```
 * @property readinessCheckName Unique name describing the readiness check.
 * @property resourceSetName Name describing the resource set that will be monitored for readiness.
 * The following arguments are optional:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class ReadinessCheckArgs(
    public val readinessCheckName: Output<String>? = null,
    public val resourceSetName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53recoveryreadiness.ReadinessCheckArgs> {
    override fun toJava(): com.pulumi.aws.route53recoveryreadiness.ReadinessCheckArgs =
        com.pulumi.aws.route53recoveryreadiness.ReadinessCheckArgs.builder()
            .readinessCheckName(readinessCheckName?.applyValue({ args0 -> args0 }))
            .resourceSetName(resourceSetName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReadinessCheckArgs].
 */
@PulumiTagMarker
public class ReadinessCheckArgsBuilder internal constructor() {
    private var readinessCheckName: Output<String>? = null

    private var resourceSetName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Unique name describing the readiness check.
     */
    @JvmName("dapjxrfykmfdnnwl")
    public suspend fun readinessCheckName(`value`: Output<String>) {
        this.readinessCheckName = value
    }

    /**
     * @param value Name describing the resource set that will be monitored for readiness.
     * The following arguments are optional:
     */
    @JvmName("xivolsaftvcybxwt")
    public suspend fun resourceSetName(`value`: Output<String>) {
        this.resourceSetName = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("yhvlvowfyviymdhw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Unique name describing the readiness check.
     */
    @JvmName("axjwpysmypwqanba")
    public suspend fun readinessCheckName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessCheckName = mapped
    }

    /**
     * @param value Name describing the resource set that will be monitored for readiness.
     * The following arguments are optional:
     */
    @JvmName("jhdcucndelyoxced")
    public suspend fun resourceSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSetName = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("awbvteijduvufbkw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("gyvareyvkgajrucs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReadinessCheckArgs = ReadinessCheckArgs(
        readinessCheckName = readinessCheckName,
        resourceSetName = resourceSetName,
        tags = tags,
    )
}
