@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [RecoveryGroup].
 */
@PulumiTagMarker
public class RecoveryGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RecoveryGroupArgs = RecoveryGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RecoveryGroupArgsBuilder.() -> Unit) {
        val builder = RecoveryGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RecoveryGroup {
        val builtJavaResource =
            com.pulumi.aws.route53recoveryreadiness.RecoveryGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RecoveryGroup(builtJavaResource)
    }
}

/**
 * Provides an AWS Route 53 Recovery Readiness Recovery Group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53recoveryreadiness.RecoveryGroup("example", {recoveryGroupName: "my-high-availability-app"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53recoveryreadiness.RecoveryGroup("example", recovery_group_name="my-high-availability-app")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53RecoveryReadiness.RecoveryGroup("example", new()
 *     {
 *         RecoveryGroupName = "my-high-availability-app",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53recoveryreadiness"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53recoveryreadiness.NewRecoveryGroup(ctx, "example", &route53recoveryreadiness.RecoveryGroupArgs{
 * 			RecoveryGroupName: pulumi.String("my-high-availability-app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoveryreadiness.RecoveryGroup;
 * import com.pulumi.aws.route53recoveryreadiness.RecoveryGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RecoveryGroup("example", RecoveryGroupArgs.builder()
 *             .recoveryGroupName("my-high-availability-app")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53recoveryreadiness:RecoveryGroup
 *     properties:
 *       recoveryGroupName: my-high-availability-app
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Readiness recovery groups using the recovery group name. For example:
 * ```sh
 * $ pulumi import aws:route53recoveryreadiness/recoveryGroup:RecoveryGroup my-high-availability-app my-high-availability-app
 * ```
 */
public class RecoveryGroup internal constructor(
    override val javaResource: com.pulumi.aws.route53recoveryreadiness.RecoveryGroup,
) : KotlinCustomResource(javaResource, RecoveryGroupMapper) {
    /**
     * ARN of the recovery group
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * List of cell arns to add as nested fault domains within this recovery group
     */
    public val cells: Output<List<String>>?
        get() = javaResource.cells().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * A unique name describing the recovery group.
     * The following argument are optional:
     */
    public val recoveryGroupName: Output<String>
        get() = javaResource.recoveryGroupName().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RecoveryGroupMapper : ResourceMapper<RecoveryGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53recoveryreadiness.RecoveryGroup::class == javaResource::class

    override fun map(javaResource: Resource): RecoveryGroup = RecoveryGroup(
        javaResource as
            com.pulumi.aws.route53recoveryreadiness.RecoveryGroup,
    )
}

/**
 * @see [RecoveryGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RecoveryGroup].
 */
public suspend fun recoveryGroup(
    name: String,
    block: suspend RecoveryGroupResourceBuilder.() -> Unit,
): RecoveryGroup {
    val builder = RecoveryGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RecoveryGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun recoveryGroup(name: String): RecoveryGroup {
    val builder = RecoveryGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
