@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin

import com.pulumi.aws.route53recoveryreadiness.kotlin.outputs.ResourceSetResource
import com.pulumi.aws.route53recoveryreadiness.kotlin.outputs.ResourceSetResource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ResourceSet].
 */
@PulumiTagMarker
public class ResourceSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceSetArgs = ResourceSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceSetArgsBuilder.() -> Unit) {
        val builder = ResourceSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceSet {
        val builtJavaResource =
            com.pulumi.aws.route53recoveryreadiness.ResourceSet(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResourceSet(builtJavaResource)
    }
}

/**
 * Provides an AWS Route 53 Recovery Readiness Resource Set.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53recoveryreadiness.ResourceSet("example", {
 *     resourceSetName: my_cw_alarm_set,
 *     resourceSetType: "AWS::CloudWatch::Alarm",
 *     resources: [{
 *         resourceArn: exampleAwsCloudwatchMetricAlarm.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53recoveryreadiness.ResourceSet("example",
 *     resource_set_name=my_cw_alarm_set,
 *     resource_set_type="AWS::CloudWatch::Alarm",
 *     resources=[{
 *         "resource_arn": example_aws_cloudwatch_metric_alarm["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53RecoveryReadiness.ResourceSet("example", new()
 *     {
 *         ResourceSetName = my_cw_alarm_set,
 *         ResourceSetType = "AWS::CloudWatch::Alarm",
 *         Resources = new[]
 *         {
 *             new Aws.Route53RecoveryReadiness.Inputs.ResourceSetResourceArgs
 *             {
 *                 ResourceArn = exampleAwsCloudwatchMetricAlarm.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53recoveryreadiness"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53recoveryreadiness.NewResourceSet(ctx, "example", &route53recoveryreadiness.ResourceSetArgs{
 * 			ResourceSetName: pulumi.Any(my_cw_alarm_set),
 * 			ResourceSetType: pulumi.String("AWS::CloudWatch::Alarm"),
 * 			Resources: route53recoveryreadiness.ResourceSetResourceArray{
 * 				&route53recoveryreadiness.ResourceSetResourceArgs{
 * 					ResourceArn: pulumi.Any(exampleAwsCloudwatchMetricAlarm.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoveryreadiness.ResourceSet;
 * import com.pulumi.aws.route53recoveryreadiness.ResourceSetArgs;
 * import com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceSet("example", ResourceSetArgs.builder()
 *             .resourceSetName(my_cw_alarm_set)
 *             .resourceSetType("AWS::CloudWatch::Alarm")
 *             .resources(ResourceSetResourceArgs.builder()
 *                 .resourceArn(exampleAwsCloudwatchMetricAlarm.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53recoveryreadiness:ResourceSet
 *     properties:
 *       resourceSetName: ${["my-cw-alarm-set"]}
 *       resourceSetType: AWS::CloudWatch::Alarm
 *       resources:
 *         - resourceArn: ${exampleAwsCloudwatchMetricAlarm.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Readiness resource set name using the resource set name. For example:
 * ```sh
 * $ pulumi import aws:route53recoveryreadiness/resourceSet:ResourceSet my-cw-alarm-set example
 * ```
 */
public class ResourceSet internal constructor(
    override val javaResource: com.pulumi.aws.route53recoveryreadiness.ResourceSet,
) : KotlinCustomResource(javaResource, ResourceSetMapper) {
    /**
     * ARN of the resource set
     * * `resources.#.component_id` - Unique identified for DNS Target Resources, use for readiness checks.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Unique name describing the resource set.
     */
    public val resourceSetName: Output<String>
        get() = javaResource.resourceSetName().applyValue({ args0 -> args0 })

    /**
     * Type of the resources in the resource set.
     */
    public val resourceSetType: Output<String>
        get() = javaResource.resourceSetType().applyValue({ args0 -> args0 })

    /**
     * List of resources to add to this resource set. See below.
     * The following arguments are optional:
     */
    public val resources: Output<List<ResourceSetResource>>
        get() = javaResource.resources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ResourceSetMapper : ResourceMapper<ResourceSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53recoveryreadiness.ResourceSet::class == javaResource::class

    override fun map(javaResource: Resource): ResourceSet = ResourceSet(
        javaResource as
            com.pulumi.aws.route53recoveryreadiness.ResourceSet,
    )
}

/**
 * @see [ResourceSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceSet].
 */
public suspend fun resourceSet(name: String, block: suspend ResourceSetResourceBuilder.() -> Unit): ResourceSet {
    val builder = ResourceSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceSet(name: String): ResourceSet {
    val builder = ResourceSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
