@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin

import com.pulumi.aws.route53recoveryreadiness.ResourceSetArgs.builder
import com.pulumi.aws.route53recoveryreadiness.kotlin.inputs.ResourceSetResourceArgs
import com.pulumi.aws.route53recoveryreadiness.kotlin.inputs.ResourceSetResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Route 53 Recovery Readiness Resource Set.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53recoveryreadiness.ResourceSet("example", {
 *     resourceSetName: my_cw_alarm_set,
 *     resourceSetType: "AWS::CloudWatch::Alarm",
 *     resources: [{
 *         resourceArn: exampleAwsCloudwatchMetricAlarm.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53recoveryreadiness.ResourceSet("example",
 *     resource_set_name=my_cw_alarm_set,
 *     resource_set_type="AWS::CloudWatch::Alarm",
 *     resources=[{
 *         "resource_arn": example_aws_cloudwatch_metric_alarm["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53RecoveryReadiness.ResourceSet("example", new()
 *     {
 *         ResourceSetName = my_cw_alarm_set,
 *         ResourceSetType = "AWS::CloudWatch::Alarm",
 *         Resources = new[]
 *         {
 *             new Aws.Route53RecoveryReadiness.Inputs.ResourceSetResourceArgs
 *             {
 *                 ResourceArn = exampleAwsCloudwatchMetricAlarm.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53recoveryreadiness"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53recoveryreadiness.NewResourceSet(ctx, "example", &route53recoveryreadiness.ResourceSetArgs{
 * 			ResourceSetName: pulumi.Any(my_cw_alarm_set),
 * 			ResourceSetType: pulumi.String("AWS::CloudWatch::Alarm"),
 * 			Resources: route53recoveryreadiness.ResourceSetResourceArray{
 * 				&route53recoveryreadiness.ResourceSetResourceArgs{
 * 					ResourceArn: pulumi.Any(exampleAwsCloudwatchMetricAlarm.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoveryreadiness.ResourceSet;
 * import com.pulumi.aws.route53recoveryreadiness.ResourceSetArgs;
 * import com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceSet("example", ResourceSetArgs.builder()
 *             .resourceSetName(my_cw_alarm_set)
 *             .resourceSetType("AWS::CloudWatch::Alarm")
 *             .resources(ResourceSetResourceArgs.builder()
 *                 .resourceArn(exampleAwsCloudwatchMetricAlarm.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53recoveryreadiness:ResourceSet
 *     properties:
 *       resourceSetName: ${["my-cw-alarm-set"]}
 *       resourceSetType: AWS::CloudWatch::Alarm
 *       resources:
 *         - resourceArn: ${exampleAwsCloudwatchMetricAlarm.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Readiness resource set name using the resource set name. For example:
 * ```sh
 * $ pulumi import aws:route53recoveryreadiness/resourceSet:ResourceSet my-cw-alarm-set example
 * ```
 * @property resourceSetName Unique name describing the resource set.
 * @property resourceSetType Type of the resources in the resource set.
 * @property resources List of resources to add to this resource set. See below.
 * The following arguments are optional:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class ResourceSetArgs(
    public val resourceSetName: Output<String>? = null,
    public val resourceSetType: Output<String>? = null,
    public val resources: Output<List<ResourceSetResourceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53recoveryreadiness.ResourceSetArgs> {
    override fun toJava(): com.pulumi.aws.route53recoveryreadiness.ResourceSetArgs =
        com.pulumi.aws.route53recoveryreadiness.ResourceSetArgs.builder()
            .resourceSetName(resourceSetName?.applyValue({ args0 -> args0 }))
            .resourceSetType(resourceSetType?.applyValue({ args0 -> args0 }))
            .resources(
                resources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceSetArgs].
 */
@PulumiTagMarker
public class ResourceSetArgsBuilder internal constructor() {
    private var resourceSetName: Output<String>? = null

    private var resourceSetType: Output<String>? = null

    private var resources: Output<List<ResourceSetResourceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Unique name describing the resource set.
     */
    @JvmName("rfdpwnhbwxldpcln")
    public suspend fun resourceSetName(`value`: Output<String>) {
        this.resourceSetName = value
    }

    /**
     * @param value Type of the resources in the resource set.
     */
    @JvmName("xrbxhwprcaeeqtar")
    public suspend fun resourceSetType(`value`: Output<String>) {
        this.resourceSetType = value
    }

    /**
     * @param value List of resources to add to this resource set. See below.
     * The following arguments are optional:
     */
    @JvmName("kvsotfuyqoxakoco")
    public suspend fun resources(`value`: Output<List<ResourceSetResourceArgs>>) {
        this.resources = value
    }

    @JvmName("hqeumqpkwaitujme")
    public suspend fun resources(vararg values: Output<ResourceSetResourceArgs>) {
        this.resources = Output.all(values.asList())
    }

    /**
     * @param values List of resources to add to this resource set. See below.
     * The following arguments are optional:
     */
    @JvmName("neorcnjphgadcilo")
    public suspend fun resources(values: List<Output<ResourceSetResourceArgs>>) {
        this.resources = Output.all(values)
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("blftlsdeyvldgkjj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Unique name describing the resource set.
     */
    @JvmName("rkuxtyrjdahmwwnf")
    public suspend fun resourceSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSetName = mapped
    }

    /**
     * @param value Type of the resources in the resource set.
     */
    @JvmName("xtpfahppmqphuqah")
    public suspend fun resourceSetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSetType = mapped
    }

    /**
     * @param value List of resources to add to this resource set. See below.
     * The following arguments are optional:
     */
    @JvmName("phrnnkxtabdafwkp")
    public suspend fun resources(`value`: List<ResourceSetResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument List of resources to add to this resource set. See below.
     * The following arguments are optional:
     */
    @JvmName("rpwbbyobfffufuum")
    public suspend fun resources(argument: List<suspend ResourceSetResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceSetResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param argument List of resources to add to this resource set. See below.
     * The following arguments are optional:
     */
    @JvmName("supuoosxolbnpyap")
    public suspend fun resources(vararg argument: suspend ResourceSetResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceSetResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param argument List of resources to add to this resource set. See below.
     * The following arguments are optional:
     */
    @JvmName("wnpqkhsyhkfopvjl")
    public suspend fun resources(argument: suspend ResourceSetResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceSetResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param values List of resources to add to this resource set. See below.
     * The following arguments are optional:
     */
    @JvmName("oibbgkdvvoktepmh")
    public suspend fun resources(vararg values: ResourceSetResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("kwiuvrcmgkjcluhj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("fbtvkwqetjhhkvrh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResourceSetArgs = ResourceSetArgs(
        resourceSetName = resourceSetName,
        resourceSetType = resourceSetType,
        resources = resources,
        tags = tags,
    )
}
