@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin.inputs

import com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property domainName DNS Name that acts as the ingress point to a portion of application.
 * @property hostedZoneArn Hosted Zone ARN that contains the DNS record with the provided name of target resource.
 * @property recordSetId Route53 record set id to uniquely identify a record given a `domain_name` and a `record_type`.
 * @property recordType Type of DNS Record of target resource.
 * @property targetResource Target resource the R53 record specified with the above params points to.
 */
public data class ResourceSetResourceDnsTargetResourceArgs(
    public val domainName: Output<String>,
    public val hostedZoneArn: Output<String>? = null,
    public val recordSetId: Output<String>? = null,
    public val recordType: Output<String>? = null,
    public val targetResource: Output<ResourceSetResourceDnsTargetResourceTargetResourceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceArgs> {
    override fun toJava(): com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceArgs =
        com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceArgs.builder()
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .hostedZoneArn(hostedZoneArn?.applyValue({ args0 -> args0 }))
            .recordSetId(recordSetId?.applyValue({ args0 -> args0 }))
            .recordType(recordType?.applyValue({ args0 -> args0 }))
            .targetResource(
                targetResource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceSetResourceDnsTargetResourceArgs].
 */
@PulumiTagMarker
public class ResourceSetResourceDnsTargetResourceArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var hostedZoneArn: Output<String>? = null

    private var recordSetId: Output<String>? = null

    private var recordType: Output<String>? = null

    private var targetResource: Output<ResourceSetResourceDnsTargetResourceTargetResourceArgs>? = null

    /**
     * @param value DNS Name that acts as the ingress point to a portion of application.
     */
    @JvmName("sxtxcdiqqjhxqrsc")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Hosted Zone ARN that contains the DNS record with the provided name of target resource.
     */
    @JvmName("ovfsbsqldpmmpbou")
    public suspend fun hostedZoneArn(`value`: Output<String>) {
        this.hostedZoneArn = value
    }

    /**
     * @param value Route53 record set id to uniquely identify a record given a `domain_name` and a `record_type`.
     */
    @JvmName("rdpwkxsgfybbedsc")
    public suspend fun recordSetId(`value`: Output<String>) {
        this.recordSetId = value
    }

    /**
     * @param value Type of DNS Record of target resource.
     */
    @JvmName("hpextrsyrkyoescb")
    public suspend fun recordType(`value`: Output<String>) {
        this.recordType = value
    }

    /**
     * @param value Target resource the R53 record specified with the above params points to.
     */
    @JvmName("dpavofaxruqhqwdn")
    public suspend fun targetResource(`value`: Output<ResourceSetResourceDnsTargetResourceTargetResourceArgs>) {
        this.targetResource = value
    }

    /**
     * @param value DNS Name that acts as the ingress point to a portion of application.
     */
    @JvmName("wijacxvjsoyainyd")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Hosted Zone ARN that contains the DNS record with the provided name of target resource.
     */
    @JvmName("kiqqpdjawdqjlsra")
    public suspend fun hostedZoneArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostedZoneArn = mapped
    }

    /**
     * @param value Route53 record set id to uniquely identify a record given a `domain_name` and a `record_type`.
     */
    @JvmName("kvwrxnvwrvimjbom")
    public suspend fun recordSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordSetId = mapped
    }

    /**
     * @param value Type of DNS Record of target resource.
     */
    @JvmName("xdfxtlhhsqttndoa")
    public suspend fun recordType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordType = mapped
    }

    /**
     * @param value Target resource the R53 record specified with the above params points to.
     */
    @JvmName("mvtabkrsnkagwneo")
    public suspend fun targetResource(`value`: ResourceSetResourceDnsTargetResourceTargetResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResource = mapped
    }

    /**
     * @param argument Target resource the R53 record specified with the above params points to.
     */
    @JvmName("wegbdlhahvrcjpvk")
    public suspend fun targetResource(argument: suspend ResourceSetResourceDnsTargetResourceTargetResourceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetResourceDnsTargetResourceTargetResourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.targetResource = mapped
    }

    internal fun build(): ResourceSetResourceDnsTargetResourceArgs =
        ResourceSetResourceDnsTargetResourceArgs(
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            hostedZoneArn = hostedZoneArn,
            recordSetId = recordSetId,
            recordType = recordType,
            targetResource = targetResource,
        )
}
