@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin.inputs

import com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName Domain name that is targeted.
 * @property recordSetId Resource record set ID that is targeted.
 */
public data class ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs(
    public val domainName: Output<String>? = null,
    public val recordSetId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs> {
    override fun toJava(): com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs =
        com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .recordSetId(recordSetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs].
 */
@PulumiTagMarker
public class ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var recordSetId: Output<String>? = null

    /**
     * @param value Domain name that is targeted.
     */
    @JvmName("luhysnjmhigrwtxg")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Resource record set ID that is targeted.
     */
    @JvmName("orhjfywyhierrixd")
    public suspend fun recordSetId(`value`: Output<String>) {
        this.recordSetId = value
    }

    /**
     * @param value Domain name that is targeted.
     */
    @JvmName("eeondqhvtbqawmeg")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Resource record set ID that is targeted.
     */
    @JvmName("wflroqekultsfjds")
    public suspend fun recordSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordSetId = mapped
    }

    internal fun build(): ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs =
        ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs(
            domainName = domainName,
            recordSetId = recordSetId,
        )
}
