@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property componentId
 * @property dnsTargetResource Component for DNS/Routing Control Readiness Checks.
 * @property readinessScopes Recovery group ARN or cell ARN that contains this resource set.
 * @property resourceArn ARN of the resource.
 */
public data class ResourceSetResource(
    public val componentId: String? = null,
    public val dnsTargetResource: ResourceSetResourceDnsTargetResource? = null,
    public val readinessScopes: List<String>? = null,
    public val resourceArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53recoveryreadiness.outputs.ResourceSetResource): ResourceSetResource = ResourceSetResource(
            componentId = javaType.componentId().map({ args0 -> args0 }).orElse(null),
            dnsTargetResource = javaType.dnsTargetResource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53recoveryreadiness.kotlin.outputs.ResourceSetResourceDnsTargetResource.Companion.toKotlin(args0)
                })
            }).orElse(null),
            readinessScopes = javaType.readinessScopes().map({ args0 -> args0 }),
            resourceArn = javaType.resourceArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
