@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rum.kotlin

import com.pulumi.aws.rum.kotlin.outputs.AppMonitorAppMonitorConfiguration
import com.pulumi.aws.rum.kotlin.outputs.AppMonitorCustomEvents
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.rum.kotlin.outputs.AppMonitorAppMonitorConfiguration.Companion.toKotlin as appMonitorAppMonitorConfigurationToKotlin
import com.pulumi.aws.rum.kotlin.outputs.AppMonitorCustomEvents.Companion.toKotlin as appMonitorCustomEventsToKotlin

/**
 * Builder for [AppMonitor].
 */
@PulumiTagMarker
public class AppMonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppMonitorArgs = AppMonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppMonitorArgsBuilder.() -> Unit) {
        val builder = AppMonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppMonitor {
        val builtJavaResource = com.pulumi.aws.rum.AppMonitor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AppMonitor(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch RUM App Monitor resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rum.AppMonitor("example", {
 *     name: "example",
 *     domain: "localhost",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rum.AppMonitor("example",
 *     name="example",
 *     domain="localhost")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rum.AppMonitor("example", new()
 *     {
 *         Name = "example",
 *         Domain = "localhost",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rum"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rum.NewAppMonitor(ctx, "example", &rum.AppMonitorArgs{
 * 			Name:   pulumi.String("example"),
 * 			Domain: pulumi.String("localhost"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rum.AppMonitor;
 * import com.pulumi.aws.rum.AppMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppMonitor("example", AppMonitorArgs.builder()
 *             .name("example")
 *             .domain("localhost")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rum:AppMonitor
 *     properties:
 *       name: example
 *       domain: localhost
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloudwatch RUM App Monitor using the `name`. For example:
 * ```sh
 * $ pulumi import aws:rum/appMonitor:AppMonitor example example
 * ```
 */
public class AppMonitor internal constructor(
    override val javaResource: com.pulumi.aws.rum.AppMonitor,
) : KotlinCustomResource(javaResource, AppMonitorMapper) {
    /**
     * configuration data for the app monitor. See app_monitor_configuration below.
     */
    public val appMonitorConfiguration: Output<AppMonitorAppMonitorConfiguration>
        get() = javaResource.appMonitorConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                appMonitorAppMonitorConfigurationToKotlin(args0)
            })
        })

    /**
     * The unique ID of the app monitor. Useful for JS templates.
     */
    public val appMonitorId: Output<String>
        get() = javaResource.appMonitorId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) specifying the app monitor.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
     */
    public val customEvents: Output<AppMonitorCustomEvents>
        get() = javaResource.customEvents().applyValue({ args0 ->
            args0.let({ args0 ->
                appMonitorCustomEventsToKotlin(args0)
            })
        })

    /**
     * Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter  specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges. Default value is `false`.
     */
    public val cwLogEnabled: Output<Boolean>?
        get() = javaResource.cwLogEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the log group where the copies are stored.
     */
    public val cwLogGroup: Output<String>
        get() = javaResource.cwLogGroup().applyValue({ args0 -> args0 })

    /**
     * The top-level internet domain name for which your application has administrative authority.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The name of the log stream.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AppMonitorMapper : ResourceMapper<AppMonitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rum.AppMonitor::class == javaResource::class

    override fun map(javaResource: Resource): AppMonitor = AppMonitor(
        javaResource as
            com.pulumi.aws.rum.AppMonitor,
    )
}

/**
 * @see [AppMonitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppMonitor].
 */
public suspend fun appMonitor(name: String, block: suspend AppMonitorResourceBuilder.() -> Unit): AppMonitor {
    val builder = AppMonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppMonitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appMonitor(name: String): AppMonitor {
    val builder = AppMonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
