@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rum.kotlin

import com.pulumi.aws.rum.MetricsDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch RUM Metrics Destination resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rum.MetricsDestination("example", {
 *     appMonitorName: exampleAwsRumAppMonitor.name,
 *     destination: "CloudWatch",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rum.MetricsDestination("example",
 *     app_monitor_name=example_aws_rum_app_monitor["name"],
 *     destination="CloudWatch")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rum.MetricsDestination("example", new()
 *     {
 *         AppMonitorName = exampleAwsRumAppMonitor.Name,
 *         Destination = "CloudWatch",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rum"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rum.NewMetricsDestination(ctx, "example", &rum.MetricsDestinationArgs{
 * 			AppMonitorName: pulumi.Any(exampleAwsRumAppMonitor.Name),
 * 			Destination:    pulumi.String("CloudWatch"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rum.MetricsDestination;
 * import com.pulumi.aws.rum.MetricsDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MetricsDestination("example", MetricsDestinationArgs.builder()
 *             .appMonitorName(exampleAwsRumAppMonitor.name())
 *             .destination("CloudWatch")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rum:MetricsDestination
 *     properties:
 *       appMonitorName: ${exampleAwsRumAppMonitor.name}
 *       destination: CloudWatch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloudwatch RUM Metrics Destination using the `id`. For example:
 * ```sh
 * $ pulumi import aws:rum/metricsDestination:MetricsDestination example example
 * ```
 * @property appMonitorName The name of the CloudWatch RUM app monitor that will send the metrics.
 * @property destination Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
 * @property destinationArn Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
 * @property iamRoleArn This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
 */
public data class MetricsDestinationArgs(
    public val appMonitorName: Output<String>? = null,
    public val destination: Output<String>? = null,
    public val destinationArn: Output<String>? = null,
    public val iamRoleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rum.MetricsDestinationArgs> {
    override fun toJava(): com.pulumi.aws.rum.MetricsDestinationArgs =
        com.pulumi.aws.rum.MetricsDestinationArgs.builder()
            .appMonitorName(appMonitorName?.applyValue({ args0 -> args0 }))
            .destination(destination?.applyValue({ args0 -> args0 }))
            .destinationArn(destinationArn?.applyValue({ args0 -> args0 }))
            .iamRoleArn(iamRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricsDestinationArgs].
 */
@PulumiTagMarker
public class MetricsDestinationArgsBuilder internal constructor() {
    private var appMonitorName: Output<String>? = null

    private var destination: Output<String>? = null

    private var destinationArn: Output<String>? = null

    private var iamRoleArn: Output<String>? = null

    /**
     * @param value The name of the CloudWatch RUM app monitor that will send the metrics.
     */
    @JvmName("doffohbsaifktbra")
    public suspend fun appMonitorName(`value`: Output<String>) {
        this.appMonitorName = value
    }

    /**
     * @param value Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
     */
    @JvmName("mtanynkmtcefolhf")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
     */
    @JvmName("ewtiexwrsjqmkcsq")
    public suspend fun destinationArn(`value`: Output<String>) {
        this.destinationArn = value
    }

    /**
     * @param value This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
     */
    @JvmName("nmugcqeefnbudnhb")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value The name of the CloudWatch RUM app monitor that will send the metrics.
     */
    @JvmName("xortgtmjahgckqwe")
    public suspend fun appMonitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appMonitorName = mapped
    }

    /**
     * @param value Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
     */
    @JvmName("fsnlvbyssbfyrflb")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
     */
    @JvmName("qswnmavvipfjlegd")
    public suspend fun destinationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationArn = mapped
    }

    /**
     * @param value This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
     */
    @JvmName("ctjsckwuskxkkfrn")
    public suspend fun iamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    internal fun build(): MetricsDestinationArgs = MetricsDestinationArgs(
        appMonitorName = appMonitorName,
        destination = destination,
        destinationArn = destinationArn,
        iamRoleArn = iamRoleArn,
    )
}
