@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rum.kotlin.inputs

import com.pulumi.aws.rum.inputs.AppMonitorAppMonitorConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowCookies If you set this to `true`, RUM web client sets two cookies, a session cookie  and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
 * @property enableXray If you set this to `true`, RUM enables X-Ray tracing for the user sessions  that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests.
 * @property excludedPages A list of URLs in your website or application to exclude from RUM data collection.
 * @property favoritePages A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.
 * @property guestRoleArn The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
 * @property identityPoolId The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
 * @property includedPages If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
 * @property sessionSampleRate Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs. The number you specify is the percentage of user sessions that will be used. Default value is `0.1`.
 * @property telemetries An array that lists the types of telemetry data that this app monitor is to collect. Valid values are `errors`, `performance`, and `http`.
 */
public data class AppMonitorAppMonitorConfigurationArgs(
    public val allowCookies: Output<Boolean>? = null,
    public val enableXray: Output<Boolean>? = null,
    public val excludedPages: Output<List<String>>? = null,
    public val favoritePages: Output<List<String>>? = null,
    public val guestRoleArn: Output<String>? = null,
    public val identityPoolId: Output<String>? = null,
    public val includedPages: Output<List<String>>? = null,
    public val sessionSampleRate: Output<Double>? = null,
    public val telemetries: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rum.inputs.AppMonitorAppMonitorConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.rum.inputs.AppMonitorAppMonitorConfigurationArgs =
        com.pulumi.aws.rum.inputs.AppMonitorAppMonitorConfigurationArgs.builder()
            .allowCookies(allowCookies?.applyValue({ args0 -> args0 }))
            .enableXray(enableXray?.applyValue({ args0 -> args0 }))
            .excludedPages(excludedPages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .favoritePages(favoritePages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .guestRoleArn(guestRoleArn?.applyValue({ args0 -> args0 }))
            .identityPoolId(identityPoolId?.applyValue({ args0 -> args0 }))
            .includedPages(includedPages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sessionSampleRate(sessionSampleRate?.applyValue({ args0 -> args0 }))
            .telemetries(telemetries?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AppMonitorAppMonitorConfigurationArgs].
 */
@PulumiTagMarker
public class AppMonitorAppMonitorConfigurationArgsBuilder internal constructor() {
    private var allowCookies: Output<Boolean>? = null

    private var enableXray: Output<Boolean>? = null

    private var excludedPages: Output<List<String>>? = null

    private var favoritePages: Output<List<String>>? = null

    private var guestRoleArn: Output<String>? = null

    private var identityPoolId: Output<String>? = null

    private var includedPages: Output<List<String>>? = null

    private var sessionSampleRate: Output<Double>? = null

    private var telemetries: Output<List<String>>? = null

    /**
     * @param value If you set this to `true`, RUM web client sets two cookies, a session cookie  and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
     */
    @JvmName("qkfnytgybxrywkaa")
    public suspend fun allowCookies(`value`: Output<Boolean>) {
        this.allowCookies = value
    }

    /**
     * @param value If you set this to `true`, RUM enables X-Ray tracing for the user sessions  that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests.
     */
    @JvmName("dgwvbpxstrixiabk")
    public suspend fun enableXray(`value`: Output<Boolean>) {
        this.enableXray = value
    }

    /**
     * @param value A list of URLs in your website or application to exclude from RUM data collection.
     */
    @JvmName("dmqwmcpgspwtichv")
    public suspend fun excludedPages(`value`: Output<List<String>>) {
        this.excludedPages = value
    }

    @JvmName("aaifrmvffvfqcwig")
    public suspend fun excludedPages(vararg values: Output<String>) {
        this.excludedPages = Output.all(values.asList())
    }

    /**
     * @param values A list of URLs in your website or application to exclude from RUM data collection.
     */
    @JvmName("ilsnfejnylygrfte")
    public suspend fun excludedPages(values: List<Output<String>>) {
        this.excludedPages = Output.all(values)
    }

    /**
     * @param value A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.
     */
    @JvmName("ubshogbwhvvrsvrv")
    public suspend fun favoritePages(`value`: Output<List<String>>) {
        this.favoritePages = value
    }

    @JvmName("iieoaqniaeihfsmi")
    public suspend fun favoritePages(vararg values: Output<String>) {
        this.favoritePages = Output.all(values.asList())
    }

    /**
     * @param values A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.
     */
    @JvmName("vrjuqtlghhxivhtl")
    public suspend fun favoritePages(values: List<Output<String>>) {
        this.favoritePages = Output.all(values)
    }

    /**
     * @param value The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
     */
    @JvmName("iracsvcxgvbayirn")
    public suspend fun guestRoleArn(`value`: Output<String>) {
        this.guestRoleArn = value
    }

    /**
     * @param value The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
     */
    @JvmName("rsprbetgvocddsdi")
    public suspend fun identityPoolId(`value`: Output<String>) {
        this.identityPoolId = value
    }

    /**
     * @param value If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
     */
    @JvmName("yvpmjooctwayrurs")
    public suspend fun includedPages(`value`: Output<List<String>>) {
        this.includedPages = value
    }

    @JvmName("jpbyjrwmbvicrlev")
    public suspend fun includedPages(vararg values: Output<String>) {
        this.includedPages = Output.all(values.asList())
    }

    /**
     * @param values If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
     */
    @JvmName("jwuvcmieplxjtfoy")
    public suspend fun includedPages(values: List<Output<String>>) {
        this.includedPages = Output.all(values)
    }

    /**
     * @param value Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs. The number you specify is the percentage of user sessions that will be used. Default value is `0.1`.
     */
    @JvmName("xasygbbliedjvqea")
    public suspend fun sessionSampleRate(`value`: Output<Double>) {
        this.sessionSampleRate = value
    }

    /**
     * @param value An array that lists the types of telemetry data that this app monitor is to collect. Valid values are `errors`, `performance`, and `http`.
     */
    @JvmName("ajpnvhdmewlkidaw")
    public suspend fun telemetries(`value`: Output<List<String>>) {
        this.telemetries = value
    }

    @JvmName("vryfhgflqhdkvshl")
    public suspend fun telemetries(vararg values: Output<String>) {
        this.telemetries = Output.all(values.asList())
    }

    /**
     * @param values An array that lists the types of telemetry data that this app monitor is to collect. Valid values are `errors`, `performance`, and `http`.
     */
    @JvmName("oamtbbxtcmyhyeux")
    public suspend fun telemetries(values: List<Output<String>>) {
        this.telemetries = Output.all(values)
    }

    /**
     * @param value If you set this to `true`, RUM web client sets two cookies, a session cookie  and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
     */
    @JvmName("eureqdbyrffjnlot")
    public suspend fun allowCookies(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCookies = mapped
    }

    /**
     * @param value If you set this to `true`, RUM enables X-Ray tracing for the user sessions  that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests.
     */
    @JvmName("pvtvbybltwbuvugu")
    public suspend fun enableXray(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableXray = mapped
    }

    /**
     * @param value A list of URLs in your website or application to exclude from RUM data collection.
     */
    @JvmName("rrhglocxcvtqubhb")
    public suspend fun excludedPages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedPages = mapped
    }

    /**
     * @param values A list of URLs in your website or application to exclude from RUM data collection.
     */
    @JvmName("xyfgcsexsoeiompw")
    public suspend fun excludedPages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedPages = mapped
    }

    /**
     * @param value A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.
     */
    @JvmName("hoilkviccsqbdddd")
    public suspend fun favoritePages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.favoritePages = mapped
    }

    /**
     * @param values A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.
     */
    @JvmName("mqdaimlqcpmxbrpw")
    public suspend fun favoritePages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.favoritePages = mapped
    }

    /**
     * @param value The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
     */
    @JvmName("vlmkrihbsnbxwwij")
    public suspend fun guestRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestRoleArn = mapped
    }

    /**
     * @param value The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
     */
    @JvmName("ctwbkumshlokyutr")
    public suspend fun identityPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityPoolId = mapped
    }

    /**
     * @param value If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
     */
    @JvmName("tpobggvjfgpdnjiw")
    public suspend fun includedPages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedPages = mapped
    }

    /**
     * @param values If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
     */
    @JvmName("vkqnlnqocuxudgbm")
    public suspend fun includedPages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedPages = mapped
    }

    /**
     * @param value Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs. The number you specify is the percentage of user sessions that will be used. Default value is `0.1`.
     */
    @JvmName("gxkvlxgkykmiyiqy")
    public suspend fun sessionSampleRate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionSampleRate = mapped
    }

    /**
     * @param value An array that lists the types of telemetry data that this app monitor is to collect. Valid values are `errors`, `performance`, and `http`.
     */
    @JvmName("mufkutkmvupfedee")
    public suspend fun telemetries(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.telemetries = mapped
    }

    /**
     * @param values An array that lists the types of telemetry data that this app monitor is to collect. Valid values are `errors`, `performance`, and `http`.
     */
    @JvmName("kbevfqcalmhvijmf")
    public suspend fun telemetries(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.telemetries = mapped
    }

    internal fun build(): AppMonitorAppMonitorConfigurationArgs =
        AppMonitorAppMonitorConfigurationArgs(
            allowCookies = allowCookies,
            enableXray = enableXray,
            excludedPages = excludedPages,
            favoritePages = favoritePages,
            guestRoleArn = guestRoleArn,
            identityPoolId = identityPoolId,
            includedPages = includedPages,
            sessionSampleRate = sessionSampleRate,
            telemetries = telemetries,
        )
}
