@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rum.kotlin.inputs

import com.pulumi.aws.rum.inputs.AppMonitorCustomEventsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status Specifies whether this app monitor allows the web client to define and send custom events. The default is for custom events to be `DISABLED`. Valid values are `DISABLED` and `ENABLED`.
 */
public data class AppMonitorCustomEventsArgs(
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rum.inputs.AppMonitorCustomEventsArgs> {
    override fun toJava(): com.pulumi.aws.rum.inputs.AppMonitorCustomEventsArgs =
        com.pulumi.aws.rum.inputs.AppMonitorCustomEventsArgs.builder()
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppMonitorCustomEventsArgs].
 */
@PulumiTagMarker
public class AppMonitorCustomEventsArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Specifies whether this app monitor allows the web client to define and send custom events. The default is for custom events to be `DISABLED`. Valid values are `DISABLED` and `ENABLED`.
     */
    @JvmName("vujkuupdqgdmbdxf")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Specifies whether this app monitor allows the web client to define and send custom events. The default is for custom events to be `DISABLED`. Valid values are `DISABLED` and `ENABLED`.
     */
    @JvmName("mmtyeyjklbndrisp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): AppMonitorCustomEventsArgs = AppMonitorCustomEventsArgs(
        status = status,
    )
}
